package cn.zoecloud.core.auth;

import org.apache.commons.lang3.StringUtils;

/**
 * 默认的证书存储实现
 * @author Leo
 */
public class DefaultCredentialProvider implements CredentialProvider {
    private volatile Credential credential;

    public DefaultCredentialProvider(Credential credential) {
        setCredential(credential);
    }

    public DefaultCredentialProvider(String appKey, String appSecret) {
        setCredential(new DefaultCredential(appKey, appSecret));
    }

    @Override
    public synchronized void setCredential(Credential credential) {
        if (credential == null) {
            throw new InvalidCredentialException("credential should not be null.");
        }

        checkCredentials(credential.getAppKey(), credential.getAppSecret());
        this.credential = credential;
    }

    @Override
    public Credential getCredential() {
        if (this.credential == null) {
            throw new InvalidCredentialException("Invalid credential");
        }

        return this.credential;
    }

    private static void checkCredentials(String appKey, String appSecret) {
        if (StringUtils.isBlank(appKey)) {
            throw new InvalidCredentialException("App key should not be null or empty.");
        }
        if (StringUtils.isBlank(appSecret)) {
            throw new InvalidCredentialException("App secret should not be null or empty.");
        }
    }
}
