package cn.zoecloud.core;

import cn.zoecloud.core.auth.CredentialProvider;
import cn.zoecloud.core.auth.DefaultCredentialProvider;
import cn.zoecloud.core.internal.ZoeCloudConstants;
import cn.zoecloud.core.model.*;
import cn.zoecloud.core.operation.ZoeCloudCommandOperation;
import cn.zoecloud.core.operation.ZoeCloudGroupOperation;
import cn.zoecloud.core.operation.ZoeCloudProgramOperation;
import cn.zoecloud.core.operation.ZoeCloudTerminalOperation;
import cn.zoecloud.core.service.ServiceClient;

import static cn.zoecloud.core.util.LogUtil.logException;

/**
 * 中航云服务客户端实现
 * @author Leo
 */
public class ZoeCloudClient implements ZoeCloud {
    /**
     * 请求验证证书
     */
    private CredentialProvider credentialProvider;

    /**
     * 中航云服务接入点（URL前缀）
     */
    private String endpoint;

    private ServiceClient serviceClient;

    private ZoeCloudGroupOperation groupOperation;
    private ZoeCloudTerminalOperation terminalOperation;
    private ZoeCloudCommandOperation commandOperation;
    private ZoeCloudProgramOperation programOperation;

    public ZoeCloudClient(String appKey, String appSecret) {
        this(ZoeCloudConstants.DEFAULT_ZOEHOO_CLOUD_ENDPOINT,
                new DefaultCredentialProvider(appKey, appSecret),
                new ClientConfiguration());
    }

    public ZoeCloudClient(String endpoint, String appKey, String appSecret) {
        this(endpoint, new DefaultCredentialProvider(appKey, appSecret), new ClientConfiguration());
    }

    public ZoeCloudClient(String endpoint, CredentialProvider credentialProvider, ClientConfiguration config) {
        this.endpoint = endpoint;
        this.credentialProvider = credentialProvider;
        this.serviceClient = new ServiceClient(config);

        this.initOperations();
    }

    @Override
    public GetGroupPageResult getGroupPage(GetGroupPageRequest request) {
        return this.groupOperation.getGroupPage(request);
    }

    @Override
    public GetTerminalSingleResult getTerminal(GetTerminalSingleRequest request) {
        return this.terminalOperation.getTerminal(request);
    }

    @Override
    public GetTerminalPageResult getTerminalPage(GetTerminalPageRequest request) {
        return this.terminalOperation.getTerminalPage(request);
    }

    @Override
    public CommandResultListResult getCommandResultList(GetCommandResultListRequest request) {
        return this.commandOperation.getCommandResults(request);
    }

    @Override
    public CommandResultListResult commandOpenScreen(CommandOpenScreenRequest request) {
        return this.commandOperation.openScreen(request);
    }

    @Override
    public CommandResultListResult commandCloseScreen(CommandCloseScreenRequest request) {
        return this.commandOperation.closeScreen(request);
    }

    @Override
    public CommandResultListResult commandFetchScreenStatus(CommandFetchScreenStatusRequest request) {
        return this.commandOperation.fetchScreenStatus(request);
    }

    @Override
    public CommandResultListResult commandFetchPrograms(CommandFetchProgramsRequest request) {
        return this.commandOperation.fetchPrograms(request);
    }

    @Override
    public CommandResultListResult commandCaptureScreen(CommandCaptureScreenRequest request) {
        return this.commandOperation.captureScreen(request);
    }

    @Override
    public GetLayoutPageResult getLayoutPage(GetLayoutPageRequest request) {
        return this.programOperation.getLayoutPage(request);
    }

    @Override
    public ProgramPublishResult programPublish(ProgramPublishRequest request) {
        return this.programOperation.programPublish(request);
    }

    @Override
    public GetProgramPublishStatusResult getProgramPublishStatus(GetProgramPublishStatusRequest request) {
        return this.programOperation.getProgramPublishStatus(request);
    }

    @Override
    public GetProgramPublishDetailResult getProgramPublishDetail(GetProgramPublishDetailRequest request) {
        return this.programOperation.getProgramPublishDetail(request);
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        } catch (Exception e) {
            logException("shutdown throw exception: ", e);
        }
    }

    /**
     * 初始化操作对象
     */
    private void initOperations() {
        this.groupOperation = new ZoeCloudGroupOperation(
                this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
        this.terminalOperation = new ZoeCloudTerminalOperation(
                this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
        this.commandOperation = new ZoeCloudCommandOperation(
                this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
        this.programOperation = new ZoeCloudProgramOperation(
                this.serviceClient, this.credentialProvider.getCredential(), this.endpoint);
    }
}
