package cn.zoecloud.core;

import org.apache.commons.lang3.StringUtils;

/**
 * 服务调用异常
 * @author Leo
 */
public class ServiceException extends RuntimeException {
    private static final long serialVersionUID = 239095863350935373L;
    private String errorMessage;
    private Integer errorCode;
    private String rawResponse;

    public ServiceException() {
        super();
    }

    public ServiceException(String errorMessage) {
        super();
        this.errorMessage = errorMessage;
    }

    public ServiceException(String errorMessage, Throwable cause) {
        super(null, cause);
        this.errorMessage = errorMessage;
    }

    public ServiceException(String errorMessage, Integer errorCode, String rawResponse) {
        super();
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.rawResponse = rawResponse;
    }

    public ServiceException(String errorMessage, Integer errorCode, String rawResponse, Throwable cause) {
        super(null, cause);
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.rawResponse = rawResponse;
    }

    private String formatRawResponse() {
        if (StringUtils.isBlank(this.rawResponse)) {
            return "";
        }
        return String.format("\n[Response]:\n%s", this.rawResponse);
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + "\n[ErrorCode]: " + this.errorCode + "\n" + this.formatRawResponse();
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public String getRawResponse() {
        return rawResponse;
    }
}
