package cn.zoecloud.core;

/**
 * 客户端异常
 * @author Leo
 */
public class ClientException extends RuntimeException {
    private static final long serialVersionUID = 1320548683798479848L;
    private String errorMessage;
    private String errorCode;

    public ClientException() {
    }

    public ClientException(String errorMessage) {
        this(errorMessage, (Throwable)null);
    }

    public ClientException(Throwable cause) {
        this((String)null, cause);
    }

    public ClientException(String errorMessage, Throwable cause) {
        super((String)null, cause);
        this.errorMessage = errorMessage;
        this.errorCode = ClientErrorCode.UNKNOWN;
    }

    public ClientException(String errorMessage, String errorCode) {
        this(errorMessage, errorCode, (Throwable)null);
    }

    public ClientException(String errorMessage, String errorCode, Throwable cause) {
        this(errorMessage, cause);
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage() + "\n[ErrorCode]: " + (this.errorCode != null ? this.errorCode : "");
    }
}