/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.migration.MigrationManager;
import step.migration.MigrationManagerPlugin;
import step.migration.tasks.MigrateArtefactsToPlans;
import step.migration.tasks.MigrateFunctions;
import step.migration.tasks.RemoveLocalFunctions;
import step.migration.tasks.RenameArtefactType;
import step.migration.tasks.ScreenTemplateArtefactTableMigrationTask;
import step.migration.tasks.ScreenTemplateMigrationTask;
import step.migration.tasks.SetSchedulerTaskAttributes;

@Plugin(dependencies={MigrationManagerPlugin.class})
public class MigrationManagerTasksPlugin
extends AbstractControllerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MigrationManagerTasksPlugin.class);

    public void executionControllerStart(GlobalContext context) throws Exception {
        MigrationManager migrationManager = (MigrationManager)context.get(MigrationManager.class);
        migrationManager.register(new RenameArtefactType());
        migrationManager.register(new MigrateFunctions());
        migrationManager.register(new ScreenTemplateMigrationTask());
        migrationManager.register(new SetSchedulerTaskAttributes());
        migrationManager.register(new RemoveLocalFunctions());
        migrationManager.register(new MigrateArtefactsToPlans());
        migrationManager.register(new ScreenTemplateArtefactTableMigrationTask());
    }
}

