/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import com.mongodb.client.MongoCollection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.Version;
import step.migration.MigrationTask;

public class ScreenTemplateArtefactTableMigrationTask
extends MigrationTask {
    private MongoCollection<Document> screenInputs;

    public ScreenTemplateArtefactTableMigrationTask() {
        super(new Version(3, 13, 0));
    }

    @Override
    protected void setContext(GlobalContext context) {
        this.screenInputs = context.getMongoClientSession().getMongoDatabase().getCollection("screenInputs");
    }

    @Override
    public void runUpgradeScript() {
        Document filter = new Document("screenId", (Object)"artefactTable");
        this.screenInputs.find((Bson)filter).iterator().forEachRemaining(t -> {
            try {
                t.put("screenId", (Object)"planTable");
                Document input = (Document)t.get((Object)"input");
                String inputId = input.getString((Object)"id");
                if (inputId.equals("attributes.name")) {
                    input.put("valueHtmlTemplate", (Object)"<plan-link plan-id=\"stBean.id\" description=\"stBean.attributes.name\" />");
                }
                Document idFilter = new Document("_id", t.get((Object)"_id"));
                if (!this.inputExist(inputId)) {
                    this.screenInputs.replaceOne((Bson)idFilter, t);
                    logger.info("Migrating screen input to " + t.toJson());
                } else {
                    this.screenInputs.deleteOne((Bson)idFilter);
                    logger.info("Deleted screen input " + t.toJson());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
    }

    protected boolean inputExist(String inputId) {
        Document planFilter = new Document("screenId", (Object)"planTable");
        AtomicBoolean result = new AtomicBoolean();
        this.screenInputs.find((Bson)planFilter).iterator().forEachRemaining(doc -> {
            Document i = (Document)doc.get((Object)"input");
            if (i.getString((Object)"id").equals(inputId)) {
                result.set(true);
            }
        });
        return result.get();
    }

    @Override
    public void runDowngradeScript() {
    }
}

