/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import com.mongodb.Block;
import com.mongodb.client.MongoCollection;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.Version;
import step.migration.MigrationTask;

public class SetSchedulerTaskAttributes
extends MigrationTask {
    public SetSchedulerTaskAttributes() {
        super(new Version(3, 12, 1));
    }

    @Override
    public void runUpgradeScript() {
        logger.info("Searching for tasks with no attributes.name to be migrated...");
        final MongoCollection tasks = this.context.getMongoClientSession().getMongoDatabase().getCollection("tasks");
        final AtomicInteger i = new AtomicInteger();
        Document filterTasksWithNoAttrName = new Document("attributes.name", null);
        tasks.find((Bson)filterTasksWithNoAttrName).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                try {
                    i.incrementAndGet();
                    Document filter = new Document("_id", t.get((Object)"_id"));
                    Document update = new Document("$set", (Object)new Document("attributes.name", t.get((Object)"name")));
                    tasks.updateOne((Bson)filter, (Bson)update);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        logger.info("Migrated " + i.get() + " tasks.");
    }

    @Override
    public void runDowngradeScript() {
    }
}

