/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import com.mongodb.Block;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.Version;
import step.migration.MigrationTask;

public class MigrateFunctions
extends MigrationTask {
    public MigrateFunctions() {
        super(new Version(3, 5, 0));
    }

    @Override
    public void runUpgradeScript() {
        this.migrateCallFunction(this.context);
        this.migrateGeneralScriptFunction(this.context);
        this.migrateGeneralScriptFunctions(this.context);
    }

    private void migrateGeneralScriptFunction(GlobalContext context) {
        logger.info("Searching for keywords of type 'Script' to be migrated...");
        MongoCollection functions = context.getMongoClientSession().getMongoDatabase().getCollection("functions");
        Document filter = new Document("type", (Object)"step.plugins.functions.types.GeneralScriptFunction");
        Document replacement = new Document("$set", (Object)new Document("type", (Object)"step.plugins.java.GeneralScriptFunction"));
        UpdateResult result = functions.updateMany((Bson)filter, (Bson)replacement);
        logger.info("Migrated " + result.getModifiedCount() + " artefacts of type 'step.plugins.functions.types.GeneralScriptFunction'");
    }

    private void migrateGeneralScriptFunctions(GlobalContext context) {
        logger.info("Searching for functions of type 'step.plugins.functions.types.GeneralScriptFunction' to be migrated...");
        final MongoCollection functions = context.getMongoClientSession().getMongoDatabase().getCollection("functions");
        final AtomicInteger i = new AtomicInteger();
        Document filterCallFunction = new Document("type", (Object)"step.plugins.functions.types.GeneralScriptFunction");
        functions.find((Bson)filterCallFunction).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                t.replace((Object)"type", (Object)"step.plugins.java.GeneralScriptFunction");
                Document filter = new Document("_id", t.get((Object)"_id"));
                functions.replaceOne((Bson)filter, (Object)t);
                i.incrementAndGet();
            }
        });
        logger.info("Migrated " + i.get() + " functions of type 'step.plugins.functions.types.GeneralScriptFunction'");
    }

    private void migrateCallFunction(GlobalContext context) {
        logger.info("Searching for artefacts of type 'CallFunction' to be migrated...");
        final MongoCollection artefacts = context.getMongoClientSession().getMongoDatabase().getCollection("artefacts");
        final AtomicInteger i = new AtomicInteger();
        Document filterCallFunction = new Document("_class", (Object)"CallFunction");
        artefacts.find((Bson)filterCallFunction).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                if (t.containsKey((Object)"function")) {
                    try {
                        i.incrementAndGet();
                        String function = t.getString((Object)"function");
                        Document d = new Document();
                        d.append("dynamic", (Object)false);
                        d.append("value", (Object)function);
                        t.replace((Object)"function", (Object)d);
                        Document filter = new Document("_id", t.get((Object)"_id"));
                        artefacts.replaceOne((Bson)filter, (Object)t);
                        logger.info("Migrating " + function + " to " + d.toJson());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        });
        logger.info("Migrated " + i.get() + " artefacts of type 'CallFunction'");
    }

    @Override
    public void runDowngradeScript() {
    }
}

