/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.threadmanager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import step.artefacts.reports.TestCaseReportNode;
import step.common.managedoperations.Operation;
import step.common.managedoperations.OperationDetails;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionRunnable;
import step.core.plans.Plan;
import step.plugins.threadmanager.ThreadManager;

@Path(value="/threadmanager")
public class ThreadManagerServices
extends AbstractServices {
    @GET
    @Secured(right="admin")
    @Produces(value={"application/json"})
    @Path(value="/operations/list")
    public List<OperationDetails> getCurrentOperationsList() {
        ThreadManager threadManager = (ThreadManager)((Object)this.getContext().get((Object)"ThreadManagerPlugin_Instance"));
        ArrayList<OperationDetails> operationListDetails = new ArrayList<OperationDetails>();
        for (ExecutionRunnable task : this.getScheduler().getCurrentExecutions()) {
            if (task == null) continue;
            ExecutionContext executionContext = task.getContext();
            String executionId = executionContext.getExecutionId();
            Plan plan = executionContext.getPlan();
            if (plan == null) continue;
            String planId = plan.getId().toString();
            String planName = (String)plan.getAttributes().get("name");
            String executionType = executionContext.getExecutionType();
            if ("TestSet".equals(executionType)) {
                Iterator iterator = this.getContext().getReportAccessor().getReportNodesByExecutionIDAndClass(executionId, TestCaseReportNode.class.getName());
                iterator.forEachRemaining(e -> {
                    String testcase = e.getName();
                    threadManager.getCurrentOperationsByReportNodeId(e.getId().toString()).forEach(op -> operationListDetails.add(new OperationDetails(executionId, planId, planName, testcase, op)));
                });
                continue;
            }
            threadManager.getCurrentOperations(executionContext).forEach(op -> operationListDetails.add(new OperationDetails(executionId, planId, planName, "", op)));
        }
        return operationListDetails;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/operations")
    @Secured(right="execution-read")
    public List<Operation> getCurrentOperations(@QueryParam(value="eid") String executionID) {
        ThreadManager threadManager = (ThreadManager)((Object)this.getContext().get((Object)"ThreadManagerPlugin_Instance"));
        ExecutionRunnable task = this.getExecutionRunnable(executionID);
        if (task != null) {
            return threadManager.getCurrentOperations(task.getContext());
        }
        return new ArrayList<Operation>();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/operations/{reportnodeid}")
    @Secured(right="execution-read")
    public List<Operation> getOperationsByReportNodeId(@PathParam(value="reportnodeid") String reportNodeId) {
        ThreadManager threadManager = (ThreadManager)((Object)this.getContext().get((Object)"ThreadManagerPlugin_Instance"));
        return threadManager.getCurrentOperationsByReportNodeId(reportNodeId);
    }
}

