/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.bson.types.ObjectId;
import step.commons.activation.Expression;
import step.core.GlobalContext;
import step.core.access.AccessManager;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.plugins.parametermanager.Parameter;
import step.plugins.parametermanager.ParameterScope;

@Path(value="/parameters")
public class ParameterServices
extends AbstractServices {
    private AccessManager accessManager;
    private CRUDAccessor<Parameter> parameterAccessor;
    public static final String PROTECTED_VALUE = "******";

    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.getContext();
        this.parameterAccessor = (CRUDAccessor)context.get((Object)"ParameterAccessor");
        this.accessManager = (AccessManager)context.get(AccessManager.class);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter newParameter() {
        Parameter parameter = new Parameter(new Expression(""), "", "", "");
        parameter.setPriority(1);
        if (this.hasGlobalParamRight()) {
            parameter.setScope(ParameterScope.GLOBAL);
        } else {
            parameter.setScope(ParameterScope.FUNCTION);
        }
        return parameter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter save(Parameter newParameter) {
        this.assertRights(newParameter);
        Parameter oldParameter = newParameter.getId() != null ? (Parameter)this.parameterAccessor.get(newParameter.getId()) : null;
        if (oldParameter == null) {
            newParameter.setProtectedValue(ParameterServices.isPassword(newParameter));
        } else {
            if (newParameter.getValue().equals(PROTECTED_VALUE)) {
                newParameter.setValue(oldParameter.getValue());
            }
            if (this.isProtected(oldParameter)) {
                newParameter.setProtectedValue(true);
            } else {
                newParameter.setProtectedValue(ParameterServices.isPassword(newParameter));
            }
        }
        ParameterScope scope = newParameter.getScope();
        if (scope != null && scope.equals((Object)ParameterScope.GLOBAL)) {
            newParameter.setScopeEntity(null);
        }
        String lastModificationUser = this.getSession().getUser().getUsername();
        Date lastModificationDate = new Date();
        newParameter.setLastModificationDate(lastModificationDate);
        newParameter.setLastModificationUser(lastModificationUser);
        return (Parameter)this.parameterAccessor.save((AbstractIdentifiableObject)newParameter);
    }

    protected void assertRights(Parameter newParameter) {
        if (!(newParameter.getScope() != null && newParameter.getScope() != ParameterScope.GLOBAL || this.hasGlobalParamRight())) {
            throw new RuntimeException("The user is missing the right 'param-global-write' to write global parameters.");
        }
    }

    protected boolean hasGlobalParamRight() {
        return this.accessManager.checkRightInContext(this.getSession(), "param-global-write");
    }

    protected boolean isProtected(Parameter oldParameter) {
        return oldParameter.getProtectedValue() != null && oldParameter.getProtectedValue() != false;
    }

    @POST
    @Path(value="/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter copy(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        parameter.setId(new ObjectId());
        return this.save(parameter);
    }

    @DELETE
    @Path(value="/{id}")
    @Secured(right="param-delete")
    public void delete(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        this.assertRights(parameter);
        this.parameterAccessor.remove(new ObjectId(id));
    }

    public static boolean isPassword(Parameter parameter) {
        return parameter != null && ParameterServices.isPassword(parameter.getKey());
    }

    public static boolean isPassword(String key) {
        return key != null && (key.contains("pwd") || key.contains("password"));
    }

    @GET
    @Path(value="/{id}")
    @Secured(right="param-read")
    public Parameter get(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        if (parameter != null) {
            this.maskProtectedValue(parameter);
        }
        return parameter;
    }

    protected Parameter maskProtectedValue(Parameter parameter) {
        if (this.isProtected(parameter)) {
            parameter.setValue(PROTECTED_VALUE);
        }
        return parameter;
    }

    @GET
    @Path(value="/all")
    @Secured(right="param-read")
    public List<Parameter> getAll() {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        this.parameterAccessor.getAll().forEachRemaining(p -> result.add(this.maskProtectedValue((Parameter)((Object)p))));
        return result;
    }
}

