/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.events;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import step.plugins.events.Event;

public class EventBroker {
    private ConcurrentHashMap<String, Event> events;
    private long circuitBreakerThreshold;
    private boolean advancedStatsOn;
    private boolean uniqueGroupNameOn;
    private LongAdder cumulatedPuts;
    private LongAdder cumulatedGets;
    private LongAdder cumulatedAttemptedGets;
    private LongAdder cumulatedAttemptedGroupGets;
    private LongAdder cumulatedPeeks;
    private AtomicInteger sizeWaterMark = new AtomicInteger(0);
    public static String DEFAULT_GROUP_VALUE = "<default>";
    public static String DEFAULT_NAME_VALUE = "<default>";

    public EventBroker() {
        this.circuitBreakerThreshold = 5000L;
        this.advancedStatsOn = true;
        this.uniqueGroupNameOn = true;
        this.init();
    }

    public EventBroker(long circuitBreakerThreshold, boolean advancedStatsOn, boolean hashedGroupNameOn) {
        this.circuitBreakerThreshold = circuitBreakerThreshold;
        this.advancedStatsOn = advancedStatsOn;
        this.uniqueGroupNameOn = hashedGroupNameOn;
        this.init();
    }

    private void init() {
        this.events = new ConcurrentHashMap();
        this.initStats();
    }

    public void clear() {
        this.events.clear();
    }

    public String toString() {
        return this.events.toString();
    }

    public Map<String, Event> getIdBasedEventMap() {
        return this.events;
    }

    public Map<String, Event> getIdBasedEventMap(int skip, int limit) {
        return this.events.values().stream().limit(limit).skip(skip).collect(Collectors.toMap(Event::getId, e -> e));
    }

    public long getCircuitBreakerThreshold() {
        return this.circuitBreakerThreshold;
    }

    public void setCircuitBreakerThreshold(long circuitBreakerThreshold) {
        this.circuitBreakerThreshold = circuitBreakerThreshold;
    }

    public boolean isUniqueGroupNameOn() {
        return this.uniqueGroupNameOn;
    }

    public void setUniqueGroupNameOn(boolean hashedGroupNameOn) {
        this.uniqueGroupNameOn = hashedGroupNameOn;
    }

    public int getSize() {
        return this.events.size();
    }

    private boolean hasEvent(String id) {
        if (id == null) {
            return false;
        }
        return this.events.containsKey(id);
    }

    private boolean hasEvent(String group, String name) {
        return this.hasEvent(this.lookup(group, name));
    }

    public Event put(Event event) throws Exception {
        this.clearMisunderstandings(event);
        Event ret = null;
        Event putRetEvent = null;
        String mapKey = null;
        if (event.getId() == null || event.getId().isEmpty()) {
            if (this.uniqueGroupNameOn) {
                mapKey = this.buildUniqueId(event);
            } else {
                mapKey = UUID.randomUUID().toString();
                ret = event;
            }
            event.setId(mapKey);
        } else {
            mapKey = event.getId();
        }
        event.setInsertionTimestamp(System.currentTimeMillis());
        int size = this.events.size();
        if ((long)size < this.circuitBreakerThreshold) {
            putRetEvent = this.events.put(mapKey, event);
            this.updateBrokerStats(size);
            return ret == null ? putRetEvent : ret;
        }
        throw new Exception("Broker size exceeds " + this.circuitBreakerThreshold + " events. Event with id: " + event.getId() + " was discarded.");
    }

    private void updateBrokerStats(int size) {
        if (this.advancedStatsOn) {
            this.cumulatedPuts.increment();
            if (size > this.sizeWaterMark.get()) {
                this.sizeWaterMark.set(size);
            }
        }
    }

    private void clearMisunderstandings(Event event) throws Exception {
        if (event == null) {
            throw new Exception("Event is null.");
        }
        if (event.getGroup() == null) {
            event.setGroup(DEFAULT_GROUP_VALUE);
        }
        if (event.getName() == null) {
            event.setName(DEFAULT_NAME_VALUE);
        }
    }

    private String buildUniqueId(Event event) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(event.getGroup());
        sb.append("}--{");
        sb.append(event.getName());
        sb.append("}");
        return sb.toString();
    }

    public Event get(String id) {
        if (this.advancedStatsOn) {
            this.cumulatedAttemptedGets.increment();
        }
        if (id == null || id.isEmpty()) {
            return null;
        }
        Event ret = this.events.remove(id);
        if (this.advancedStatsOn && ret != null) {
            this.cumulatedGets.increment();
        }
        if (ret != null) {
            ret.setDeletionTimestamp(System.currentTimeMillis());
        }
        return ret;
    }

    public Event peek(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        Event ret = this.events.get(id);
        if (this.advancedStatsOn && ret != null) {
            this.cumulatedPeeks.increment();
        }
        if (ret != null) {
            ret.setLastReadTimestamp(System.currentTimeMillis());
        }
        return ret;
    }

    private String lookup(String searchedGroup, String searchedName) {
        Optional<Event> event;
        if (searchedGroup == null || searchedGroup.isEmpty() || searchedGroup.equals("null")) {
            searchedGroup = "*";
        }
        if (searchedName == null || searchedName.isEmpty() || searchedName.equals("null")) {
            searchedName = "*";
        }
        if ((event = searchedName.equals("*") ? this.lookupLooseGroupBasedEvent(searchedGroup) : this.lookupNamedGroupBasedEvent(searchedGroup, searchedName)).isPresent()) {
            return event.get().getId();
        }
        return null;
    }

    private Event lookupForRemove(String searchedGroup, String searchedName) {
        String hit = this.lookup(searchedGroup, searchedName);
        Event ret = null;
        while (hit != null && (ret = this.events.remove(hit)) == null) {
            hit = this.lookup(searchedGroup, searchedName);
        }
        if (this.advancedStatsOn && ret != null) {
            this.cumulatedGets.increment();
        }
        return ret;
    }

    private Optional<Event> lookupNamedGroupBasedEvent(String searchedGroup, String searchedName) {
        return this.events.values().stream().filter(e -> e.getGroup().equals(searchedGroup) || searchedGroup.equals("*")).filter(e -> e.getName().equals(searchedName) || searchedName.equals("*")).findAny();
    }

    private Optional<Event> lookupLooseGroupBasedEvent(String searchedGroup) {
        return this.events.values().stream().filter(e -> e.getGroup().equals(searchedGroup) || searchedGroup.equals("*")).findAny();
    }

    public Event peek(String group, String name) {
        return this.peek(this.lookup(group, name));
    }

    public void clearGroup(String group) {
        while (this.hasEvent(group, null)) {
            this.events.remove(this.lookup(group, null));
        }
    }

    public Event get(String group, String name) {
        if (this.advancedStatsOn) {
            this.cumulatedAttemptedGroupGets.increment();
        }
        return this.lookupForRemove(group, name);
    }

    public void setAdvancedStatsOn(boolean statsOn) {
        this.advancedStatsOn = statsOn;
    }

    public boolean getAdvancedStatsOn() {
        return this.advancedStatsOn;
    }

    public long getCumulatedPuts() {
        return this.cumulatedPuts.longValue();
    }

    public long getCumulatedGets() {
        return this.cumulatedGets.longValue();
    }

    public long getCumulatedAttemptedGets() {
        return this.cumulatedAttemptedGets.longValue();
    }

    public long getCumulatedAttemptedGroupGets() {
        return this.cumulatedAttemptedGroupGets.longValue();
    }

    public long getCumulatedPeeks() {
        return this.cumulatedPeeks.longValue();
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("s_advStatsOn", this.getAdvancedStatsOn());
        stats.put("s_circuitBreakerThreshold", this.getCircuitBreakerThreshold());
        stats.put("d_size", this.getSize());
        stats.put("d_sizeWaterMark", this.getSizeWaterMark());
        stats.put("d_youngestEvent", this.findYoungestEvent());
        stats.put("d_oldestEvent", this.findOldestEvent());
        if (this.getAdvancedStatsOn()) {
            stats.put("a_cumulatedPuts", this.getCumulatedPuts());
            stats.put("a_cumulatedGets", this.getCumulatedGets());
            stats.put("a_cumulatedAttemptedGets", this.getCumulatedAttemptedGets());
            stats.put("a_cumulatedAttemptedGroupGets", this.getCumulatedAttemptedGroupGets());
            stats.put("a_cumulatedPeeks", this.getCumulatedPeeks());
        }
        return stats;
    }

    public Map<String, Object> getGroupStats(String group) {
        if (group == null || group.isEmpty()) {
            throw new RuntimeException("Groupname is null or empty.");
        }
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("g_" + group + "_size", this.getSizeForGroup(group));
        stats.put("g_" + group + "_youngestEvent", this.findYoungestEventForGroup(group));
        stats.put("g_" + group + "_oldestEvent", this.findOldestEventForGroup(group));
        return stats;
    }

    public int getSizeWaterMark() {
        return this.sizeWaterMark.get();
    }

    public Event findOldestEvent() {
        Optional<Event> event = this.events.values().stream().min(Comparator.comparing(Event::getInsertionTimestamp));
        if (event.isPresent()) {
            return event.get();
        }
        return null;
    }

    public Event findYoungestEvent() {
        Optional<Event> event = this.events.values().stream().max(Comparator.comparing(Event::getInsertionTimestamp));
        if (event.isPresent()) {
            return event.get();
        }
        return null;
    }

    public int getSizeForGroup(String group) {
        try {
            return this.events.values().stream().filter(e -> e.getGroup().equals(group)).map(e -> 1).reduce((x, y) -> x + y).get();
        }
        catch (NoSuchElementException e2) {
            return 0;
        }
    }

    public Event findYoungestEventForGroup(String group) {
        return this.events.values().stream().filter(e -> e.getGroup().equals(group)).max(Comparator.comparing(Event::getInsertionTimestamp)).get();
    }

    public Event findOldestEventForGroup(String group) {
        return this.events.values().stream().filter(e -> e.getGroup().equals(group)).min(Comparator.comparing(Event::getInsertionTimestamp)).get();
    }

    public void clearStats() {
        this.initStats();
    }

    private void initStats() {
        this.cumulatedPuts = new LongAdder();
        this.cumulatedGets = new LongAdder();
        this.cumulatedAttemptedGets = new LongAdder();
        this.cumulatedAttemptedGroupGets = new LongAdder();
        this.cumulatedPeeks = new LongAdder();
        this.sizeWaterMark = new AtomicInteger(0);
    }

    public Set<Event> getGroupEvents(String group) {
        return this.getGroupEvents(group, 0, Integer.MAX_VALUE);
    }

    public Set<Event> getGroupEvents(String group, int skip, int limit) {
        return this.events.values().stream().filter(e -> e.getGroup().equals(group)).limit(limit).skip(skip).collect(Collectors.toSet());
    }

    public Map<String, Set<Event>> getFullGroupBasedEventMap() {
        return this.getGroupBasedEventMap(0, Integer.MAX_VALUE);
    }

    public Map<String, Set<Event>> getGroupBasedEventMap(int skip, int limit) {
        return this.events.values().stream().limit(limit).skip(skip).collect(Collectors.groupingBy(Event::getGroup, Collectors.toSet()));
    }

    public Set<String> getDistinctGroupNames() {
        return this.events.values().stream().map(e -> e.getGroup()).distinct().collect(Collectors.toSet());
    }
}

