/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.plugins.events.Event;
import step.plugins.events.EventBroker;

@Singleton
@Path(value="/eventbroker")
public class EventBrokerServices
extends AbstractServices {
    private EventBroker eb;

    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.eb = (EventBroker)this.getContext().get(EventBroker.class);
    }

    @GET
    @Path(value="/events/asIdMap")
    @Produces(value={"application/json"})
    @Secured(right="broker-read")
    public Map<String, Event> getEventBrokerIdMap() {
        return this.eb.getIdBasedEventMap();
    }

    @GET
    @Path(value="/events/asGroupMap")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    public Map<String, Set<Event>> getEventBrokerGroupMap() {
        return this.eb.getFullGroupBasedEventMap();
    }

    @GET
    @Path(value="/events/asIdMap/skip/{skip}/limit/{limit}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    public Map<String, Event> getEventBrokerIdMap(@PathParam(value="skip") int skip, @PathParam(value="limit") int limit) {
        return this.eb.getIdBasedEventMap(skip, limit);
    }

    @GET
    @Path(value="/events/asGroupMap/skip/{skip}/limit/{limit}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    public Map<String, Set<Event>> getEventBrokerGroupMap(@PathParam(value="skip") int skip, @PathParam(value="limit") int limit) {
        return this.eb.getGroupBasedEventMap(skip, limit);
    }

    @POST
    @Path(value="/event")
    @Secured(right="broker-write")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Event putEvent(Event event) throws Exception {
        return this.eb.put(event);
    }

    @GET
    @Path(value="/event/{id}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event peekEvent(@PathParam(value="id") String id) {
        return this.eb.peek(id);
    }

    @GET
    @Path(value="/event/group/{group}/name/{name}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event peekEventByGroupAndName(@PathParam(value="group") String group, @PathParam(value="name") String name) {
        return this.eb.peek(group, name);
    }

    @GET
    @Path(value="/events/group/{group}/skip/{skip}/limit/{limit}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Set<Event> getGroupSkipLimit(@PathParam(value="group") String group, @PathParam(value="skip") int skip, @PathParam(value="limit") int limit) {
        return this.eb.getGroupEvents(group, skip, limit);
    }

    @GET
    @Path(value="/events/group/{group}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Set<Event> getFullGroup(@PathParam(value="group") String group) {
        return this.eb.getGroupEvents(group);
    }

    @GET
    @Path(value="/events/groups")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Set<String> getGroups() {
        return this.eb.getDistinctGroupNames();
    }

    @GET
    @Path(value="/events/group/{group}/size")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public int getGroupSize(@PathParam(value="group") String group) {
        return this.eb.getSizeForGroup(group);
    }

    @DELETE
    @Path(value="/event/{id}")
    @Secured(right="broker-delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event consumeEvent(@PathParam(value="id") String id) {
        return this.eb.get(id);
    }

    @DELETE
    @Path(value="/event/group/{group}/name/{name}")
    @Secured(right="broker-write")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Event consumeEventByGroupAndName(@PathParam(value="group") String group, @PathParam(value="name") String name) {
        return this.eb.get(group, name);
    }

    @DELETE
    @Path(value="/events")
    @Secured(right="broker-delete")
    @Produces(value={"application/json"})
    public Map<String, Object> clear() {
        this.eb.clear();
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        successMap.put("status", "success");
        return successMap;
    }

    @DELETE
    @Path(value="/events/group/{group}")
    @Secured(right="broker-delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Map<String, Object> clearGroup(@PathParam(value="group") String group) {
        this.eb.clearGroup(group);
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        successMap.put("status", "success");
        return successMap;
    }

    @GET
    @Path(value="/events/monitoring/global")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Map<String, Object> getStats() {
        return this.eb.getStats();
    }

    @GET
    @Path(value="/events/monitoring/group/{group}")
    @Secured(right="broker-read")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Map<String, Object> getGroupStats(@PathParam(value="group") String group) throws Exception {
        return this.eb.getGroupStats(group);
    }

    @GET
    @Path(value="/events/monitoring/clear")
    @Secured(right="broker-delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Map<String, Object> clearStats() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        this.eb.clearStats();
        ret.put("status", "success");
        return ret;
    }

    @GET
    @Path(value="/events/config/circuitBreakerThreshold/{circuitBreakerThreshold}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Map<String, Object> setCircuitBreakerThreshold(@PathParam(value="circuitBreakerThreshold") long circuitBreakerThreshold) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        this.eb.setCircuitBreakerThreshold(circuitBreakerThreshold);
        ret.put("status", "success");
        return ret;
    }
}

