/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.AbstractContext;
import step.core.deployment.Session;
import step.core.objectenricher.ObjectHookRegistry;

public class TableManager {
    private ObjectHookRegistry objectHookRegistry;

    public TableManager(ObjectHookRegistry objectHookRegistry) {
        this.objectHookRegistry = objectHookRegistry;
    }

    public List<Bson> getAdditionalQueryFragmentsFromContext(Session session, String collectionID) {
        return this.getAdditionalQueryFragmentsFromContextAsBson(session, collectionID);
    }

    public List<Bson> getAdditionalQueryFragmentsFromContextAsBson(Session session, String collectionID) {
        return this.toBson(this.objectHookRegistry.getObjectFilter((AbstractContext)session).getAdditionalAttributes());
    }

    private List<Bson> toBson(Map<String, String> additionalQueryFragmentSuppliers) {
        ArrayList<Bson> bson = new ArrayList<Bson>();
        for (Map.Entry<String, String> e : additionalQueryFragmentSuppliers.entrySet()) {
            bson.add((Bson)new Document("attributes." + e.getKey(), (Object)e.getValue()));
        }
        return bson;
    }
}

