/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import java.util.ArrayList;
import java.util.List;
import step.plugins.datatable.ColumnDef;
import step.plugins.datatable.DateRangeCriterium;
import step.plugins.datatable.TextCriterium;
import step.plugins.datatable.formatters.ArrayFormatter;
import step.plugins.datatable.formatters.DateFormatter;
import step.plugins.datatable.formatters.JsonFormatter;
import step.plugins.datatable.formatters.RowAsJsonFormatter;
import step.plugins.datatable.formatters.StringFormatter;
import step.plugins.screentemplating.InputType;

public class ColumnBuilder {
    private List<ColumnDef> columns = new ArrayList<ColumnDef>();

    public ColumnBuilder addColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT, new StringFormatter(), new TextCriterium(), null));
        return this;
    }

    public ColumnBuilder addJsonColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.NONE, new JsonFormatter(), null, null));
        return this;
    }

    public ColumnBuilder addArrayColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.NONE, new ArrayFormatter(), null, null));
        return this;
    }

    public ColumnBuilder addTextWithDropdownColumn(String columnTitle, String value, List<String> distinct) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT_DROPDOWN, new StringFormatter(), new TextCriterium(), distinct));
        return this;
    }

    public ColumnBuilder addDateColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.DATE_RANGE, new DateFormatter("dd.MM.yyyy HH:mm:ss"), new DateRangeCriterium("dd.MM.yyyy"), null));
        return this;
    }

    public ColumnBuilder addTimeColumn(String columnTitle, String value) {
        this.columns.add(new ColumnDef(columnTitle, value, InputType.TEXT, new DateFormatter("HH:mm:ss"), new DateRangeCriterium("dd.MM.yyyy"), null));
        return this;
    }

    public ColumnBuilder addRowAsJson(String columnTitle) {
        this.columns.add(new ColumnDef(columnTitle, null, InputType.NONE, new RowAsJsonFormatter(), null, null));
        return this;
    }

    public List<ColumnDef> build() {
        return this.columns;
    }
}

