/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.scripteditor;

import step.core.GlobalContext;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.core.plugins.WebPlugin;
import step.functions.Function;
import step.functions.editors.FunctionEditor;
import step.functions.editors.FunctionEditorRegistry;
import step.plugins.java.GeneralScriptFunction;
import step.plugins.scripteditor.ScriptEditorServices;

@Plugin(prio=10)
public class ScriptEditorPlugin
extends AbstractPlugin {
    public void executionControllerStart(GlobalContext context) throws Exception {
        this.registerWebapp(context, "/scripteditor/");
        context.getServiceRegistrationCallback().registerService(ScriptEditorServices.class);
        FunctionEditor editor = new FunctionEditor(){

            public String getEditorPath(Function function) {
                return "root/scripteditor/" + function.getId().toString();
            }

            public boolean isValidForFunction(Function function) {
                return function instanceof GeneralScriptFunction && !((String)((GeneralScriptFunction)function).getScriptLanguage().get()).equals("java");
            }
        };
        ((FunctionEditorRegistry)context.get(FunctionEditorRegistry.class)).register(editor);
        super.executionControllerStart(context);
    }

    public WebPlugin getWebPlugin() {
        WebPlugin webPlugin = new WebPlugin();
        webPlugin.getAngularModules().add("scriptEditor");
        webPlugin.getScripts().add("scripteditor/js/controllers/scriptEditor.js");
        webPlugin.getScripts().add("scripteditor/bower_components/ace-builds/src-min-noconflict/ace.js");
        return webPlugin;
    }
}

