/*
 * Decompiled with CFR 0.152.
 */
package step.handlers.javahandler;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.functions.handler.AbstractFunctionHandler;
import step.functions.handler.FunctionHandlerFactory;
import step.functions.io.Input;
import step.functions.io.Output;
import step.grid.agent.tokenpool.TokenReservationSession;
import step.grid.agent.tokenpool.TokenSession;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.handlers.javahandler.KeywordHandler;

public class KeywordRunner {
    private static final Logger logger = LoggerFactory.getLogger(KeywordRunner.class);

    public static ExecutionContext getExecutionContext(Class<?> ... functionClass) {
        return KeywordRunner.getExecutionContext(new HashMap<String, String>(), functionClass);
    }

    public static ExecutionContext getExecutionContext(Map<String, String> properties, Class<?> ... keywordClass) {
        if (keywordClass.length == 0) {
            throw new RuntimeException("Please specify at leat one class containing the keyword definitions");
        }
        return new ExecutionContext(Arrays.asList(keywordClass), properties, true);
    }

    public static class ExecutionContext {
        protected KeywordHandler handler;
        protected List<Class<?>> functionClasses;
        private TokenSession tokenSession;
        private TokenReservationSession tokenReservationSession;

        public ExecutionContext(List<Class<?>> functionClasses, Map<String, String> properties, boolean throwExceptionOnError) {
            this.functionClasses = functionClasses;
            this.tokenSession = new TokenSession();
            this.tokenReservationSession = new TokenReservationSession();
            this.handler = new KeywordHandler(throwExceptionOnError);
            FunctionHandlerFactory factory = new FunctionHandlerFactory(new ApplicationContextBuilder(), null);
            factory.initialize((AbstractFunctionHandler)this.handler, this.tokenSession, this.tokenReservationSession, properties);
        }

        public void setThrowExceptionOnError(boolean throwExceptionOnError) {
            this.handler.setThrowExceptionOnError(throwExceptionOnError);
        }

        public Output<JsonObject> run(String function, String argument, Map<String, String> properties) throws Exception {
            return this.run(function, this.read(argument), properties);
        }

        public Output<JsonObject> run(String function, String argument) throws Exception {
            return this.run(function, this.read(argument), new HashMap<String, String>());
        }

        private JsonObject read(String argument) {
            return Json.createReader((Reader)new StringReader(argument)).readObject();
        }

        public Output<JsonObject> run(String function) throws Exception {
            return this.run(function, Json.createObjectBuilder().build(), new HashMap<String, String>());
        }

        public Output<JsonObject> run(String function, JsonObject argument) throws Exception {
            return this.run(function, argument, new HashMap<String, String>());
        }

        public Output<JsonObject> run(String function, JsonObject argument, Map<String, String> properties) throws Exception {
            return this.execute(function, argument, properties);
        }

        private Output<JsonObject> execute(String function, JsonObject argument, Map<String, String> properties) throws Exception {
            Input input = new Input();
            input.setFunction(function);
            input.setPayload((Object)argument);
            StringBuilder classes = new StringBuilder();
            this.functionClasses.forEach(cl -> classes.append(cl.getName() + ";"));
            properties.put("$keywordClasses", classes.toString());
            input.setProperties(properties);
            Output<JsonObject> output = this.handler.handle((Input<JsonObject>)input);
            if (output.getError() != null) {
                logger.error("Keyword error occurred:" + output.getError());
            }
            return output;
        }

        public void close() {
            this.tokenSession.close();
            this.tokenReservationSession.close();
        }
    }
}

