/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.js223.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import step.grid.agent.handler.AbstractMessageHandler;
import step.grid.agent.handler.context.OutputMessageBuilder;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;

public class ScriptHandler
extends AbstractMessageHandler {
    public static final String SCRIPT_LANGUAGE = "$scriptlanguage";
    public static final String SCRIPT_FILE = "$function.library.file";
    public static final String LIBRARIES_FILE = "$libraries.file";
    public static final String ERROR_HANDLER_FILE = "$errorhandler.file";
    public static final Map<String, String> scriptLangugaeMap = new ConcurrentHashMap<String, String>();
    protected ScriptEngineManager manager = new ScriptEngineManager();

    public ScriptHandler() {
        scriptLangugaeMap.put("groovy", "groovy");
        scriptLangugaeMap.put("javascript", "nashorn");
    }

    public OutputMessage handle(AgentTokenWrapper token, InputMessage message) throws Exception {
        Map properties = this.buildPropertyMap(token, message);
        File scriptFile = this.retrieveFileVersion(SCRIPT_FILE, properties).getFile();
        String scriptLanguage = (String)properties.get(SCRIPT_LANGUAGE);
        String engineName = scriptLangugaeMap.get(scriptLanguage);
        ScriptEngine engine = this.loadScriptEngine(engineName);
        OutputMessageBuilder outputBuilder = new OutputMessageBuilder();
        Bindings binding = this.createBindings(token, message, outputBuilder, properties);
        try {
            this.executeScript(scriptFile, binding, engine);
        }
        catch (Exception e) {
            this.executeErrorHandlerScript(token, properties, engine, binding);
            throw e;
        }
        return outputBuilder.build();
    }

    private void executeErrorHandlerScript(AgentTokenWrapper token, Map<String, String> properties, ScriptEngine engine, Bindings binding) throws FileNotFoundException, Exception, IOException {
        if (properties.containsKey(ERROR_HANDLER_FILE)) {
            File errorScriptFile = this.retrieveFileVersion(ERROR_HANDLER_FILE, properties).getFile();
            this.executeScript(errorScriptFile, binding, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(File scriptFile, Bindings binding, ScriptEngine engine) throws FileNotFoundException, Exception, IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scriptFile), Charset.forName("UTF-8")));){
            engine.eval((Reader)reader, binding);
        }
    }

    private Bindings createBindings(AgentTokenWrapper token, InputMessage message, OutputMessageBuilder outputBuilder, Map<String, String> properties) {
        SimpleBindings binding = new SimpleBindings();
        binding.put("input", (Object)message.getArgument());
        binding.put("inputJson", (Object)message.getArgument().toString());
        binding.put("output", (Object)outputBuilder);
        binding.put("context", (Object)outputBuilder);
        binding.put("properties", (Object)properties);
        binding.put("session", (Object)token.getTokenReservationSession());
        binding.put("tokenSession", (Object)token.getSession());
        return binding;
    }

    private ScriptEngine loadScriptEngine(String engineName) {
        ScriptEngine engine = this.manager.getEngineByName(engineName);
        if (engine == null) {
            throw new RuntimeException("Unable to find script engine with name '" + engineName + "'");
        }
        return engine;
    }
}

