/*
 * Decompiled with CFR 0.152.
 */
package step.initialization;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.access.User;
import step.core.access.UserAccessorImpl;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.versionmanager.VersionManager;

@Plugin(prio=2)
public class InitializationPlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(InitializationPlugin.class);

    public void executionControllerStart(GlobalContext context) throws Exception {
        VersionManager versionManager = (VersionManager)context.get(VersionManager.class);
        if (versionManager.getLatestControllerLog() == null) {
            logger.info("Initializing Users...");
            this.setupUsers(context);
        }
        super.executionControllerStart(context);
    }

    private void setupUsers(GlobalContext context) {
        User user = new User();
        user.setUsername("admin");
        user.setRole("admin");
        user.setPassword(UserAccessorImpl.encryptPwd((String)"init"));
        context.getUserAccessor().save((AbstractIdentifiableObject)user);
    }
}

