/*
 * Decompiled with CFR 0.152.
 */
package step.initialization;

import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.json.Json;
import javax.json.JsonObject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.CallFunction;
import step.artefacts.CallPlan;
import step.artefacts.Check;
import step.artefacts.TestCase;
import step.core.GlobalContext;
import step.core.access.User;
import step.core.access.UserAccessor;
import step.core.accessors.MongoDBAccessorHelper;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.Artefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.LocalPlanRepository;
import step.core.plans.Plan;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.functions.Function;
import step.initialization.ControllerLog;
import step.planbuilder.FunctionPlanBuilder;
import step.planbuilder.PlanBuilder;
import step.plugins.adaptergrid.FunctionRepositoryImpl;
import step.plugins.java.GeneralScriptFunction;
import step.plugins.jmeter.JMeterFunction;
import step.plugins.selenium.SeleniumFunction;

@Plugin
public class InitializationPlugin
extends AbstractPlugin {
    private static final Logger logger = LoggerFactory.getLogger(InitializationPlugin.class);

    public void executionControllerStart(GlobalContext context) throws Exception {
        org.jongo.MongoCollection controllerLogs = MongoDBAccessorHelper.getCollection((MongoClient)context.getMongoClient(), (String)"controllerlogs");
        long runCounts = controllerLogs.count();
        if (runCounts == 0L) {
            this.setupUsers(context);
            this.setupDemo(context);
            this.createSeleniumDemoPlan(context.getArtefactAccessor(), "Chrome");
        }
        this.migrateCallFunction(context);
        this.migrateGeneralScriptFunction(context);
        this.migrateGeneralScriptFunctions(context);
        this.insertLogEntry(controllerLogs);
        super.executionControllerStart(context);
    }

    private void setupUsers(GlobalContext context) {
        User user = new User();
        user.setUsername("admin");
        user.setRole("admin");
        user.setPassword(UserAccessor.encryptPwd((String)"init"));
        context.getUserAccessor().save(user);
    }

    private void migrateGeneralScriptFunction(GlobalContext context) {
        logger.info("Searching for keywords of type 'Script' to be migrated...");
        MongoCollection functions = MongoDBAccessorHelper.getMongoCollection_((MongoClient)context.getMongoClient(), (String)"functions");
        Document filter = new Document("type", (Object)"step.plugins.functions.types.GeneralScriptFunction");
        Document replacement = new Document("$set", (Object)new Document("type", (Object)"step.plugins.java.GeneralScriptFunction"));
        UpdateResult result = functions.updateMany((Bson)filter, (Bson)replacement);
        logger.info("Migrated " + result.getModifiedCount() + " artefacts of type 'step.plugins.functions.types.GeneralScriptFunction'");
    }

    private void migrateCallFunction(GlobalContext context) {
        logger.info("Searching for artefacts of type 'CallFunction' to be migrated...");
        final MongoCollection artefacts = MongoDBAccessorHelper.getMongoCollection_((MongoClient)context.getMongoClient(), (String)"artefacts");
        final AtomicInteger i = new AtomicInteger();
        Document filterCallFunction = new Document("_class", (Object)"CallFunction");
        artefacts.find((Bson)filterCallFunction).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                if (t.containsKey((Object)"function")) {
                    try {
                        i.incrementAndGet();
                        String function = t.getString((Object)"function");
                        Document d = new Document();
                        d.append("dynamic", (Object)false);
                        d.append("value", (Object)function);
                        t.replace((Object)"function", (Object)d);
                        Document filter = new Document("_id", t.get((Object)"_id"));
                        artefacts.replaceOne((Bson)filter, (Object)t);
                        logger.info("Migrating " + function + " to " + d.toJson());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        });
        logger.info("Migrated " + i.get() + " artefacts of type 'CallFunction'");
    }

    private void migrateGeneralScriptFunctions(GlobalContext context) {
        logger.info("Searching for functions of type 'step.plugins.functions.types.GeneralScriptFunction' to be migrated...");
        final MongoCollection functions = MongoDBAccessorHelper.getMongoCollection_((MongoClient)context.getMongoClient(), (String)"functions");
        final AtomicInteger i = new AtomicInteger();
        Document filterCallFunction = new Document("type", (Object)"step.plugins.functions.types.GeneralScriptFunction");
        functions.find((Bson)filterCallFunction).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                t.replace((Object)"type", (Object)"step.plugins.java.GeneralScriptFunction");
                Document filter = new Document("_id", t.get((Object)"_id"));
                functions.replaceOne((Bson)filter, (Object)t);
                i.incrementAndGet();
            }
        });
        logger.info("Migrated " + i.get() + " functions of type 'step.plugins.functions.types.GeneralScriptFunction'");
    }

    private void renameArtefactType(GlobalContext context, final String classFrom, final String classTo) {
        logger.info("Searching for artefacts of type '" + classFrom + "' to be migrated...");
        final MongoCollection artefacts = MongoDBAccessorHelper.getMongoCollection_((MongoClient)context.getMongoClient(), (String)"artefacts");
        final AtomicInteger i = new AtomicInteger();
        Document filterCallFunction = new Document("_class", (Object)classFrom);
        artefacts.find((Bson)filterCallFunction).forEach((Block)new Block<Document>(){

            public void apply(Document t) {
                try {
                    i.incrementAndGet();
                    t.put("_class", (Object)classTo);
                    Document filter = new Document("_id", t.get((Object)"_id"));
                    artefacts.replaceOne((Bson)filter, (Object)t);
                    logger.info("Migrating " + classFrom + " to " + t.toJson());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        logger.info("Migrated " + i.get() + " artefacts of type '" + classFrom + "'");
    }

    private void setArtefactNameIfEmpty(GlobalContext context) {
        org.jongo.MongoCollection functionCollection = MongoDBAccessorHelper.getCollection((MongoClient)context.getMongoClient(), (String)"functions");
        FunctionRepositoryImpl functionRepository = new FunctionRepositoryImpl(functionCollection);
        ArtefactAccessor a = context.getArtefactAccessor();
        Iterator it = a.getAll();
        while (it.hasNext()) {
            AbstractArtefact calledArtefact;
            CallPlan callPlan;
            AbstractArtefact artefact = (AbstractArtefact)it.next();
            HashMap<String, String> attributes = artefact.getAttributes();
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                artefact.setAttributes(attributes);
            }
            if (attributes.containsKey("name")) continue;
            String name = null;
            if (artefact instanceof CallFunction) {
                Function function;
                CallFunction calllFunction = (CallFunction)artefact;
                if (calllFunction.getFunctionId() != null && (function = functionRepository.getFunctionById(calllFunction.getFunctionId())) != null && function.getAttributes() != null && function.getAttributes().containsKey("name")) {
                    name = (String)function.getAttributes().get("name");
                }
            } else if (artefact instanceof CallPlan && (callPlan = (CallPlan)artefact).getArtefactId() != null && (calledArtefact = a.get(callPlan.getArtefactId())) != null && calledArtefact.getAttributes() != null && calledArtefact.getAttributes().containsKey("name")) {
                name = (String)calledArtefact.getAttributes().get("name");
            }
            if (name == null) {
                Artefact annotation = artefact.getClass().getAnnotation(Artefact.class);
                name = annotation.name().length() > 0 ? annotation.name() : artefact.getClass().getSimpleName();
            }
            attributes.put("name", name);
            a.save(artefact);
        }
    }

    private void insertLogEntry(org.jongo.MongoCollection controllerLogs) {
        ControllerLog logEntry = new ControllerLog();
        logEntry.setStart(new Date());
        controllerLogs.insert((Object)logEntry);
    }

    private void setupDemo(GlobalContext context) {
        org.jongo.MongoCollection functionCollection = MongoDBAccessorHelper.getCollection((MongoClient)context.getMongoClient(), (String)"functions");
        FunctionRepositoryImpl functionRepository = new FunctionRepositoryImpl(functionCollection);
        JsonObject schema = null;
        if (context.getConfiguration().getPropertyAsBoolean("enforceschemas", false)) {
            StringReader sr = new StringReader("{\"properties\":{\"label\":{\"type\":\"string\"}},\"required\":[\"label\"]}");
            schema = Json.createReader((Reader)sr).readObject();
            sr.close();
        }
        Function javaFunction = this.addScriptFunction(functionRepository, "Demo_Keyword_Java", "java", "../data/scripts/demo-java-keyword.jar", schema);
        Function javascriptFunction = this.addScriptFunction(functionRepository, "Demo_Keyword_Javascript", "javascript", "../data/scripts/Demo_Keyword_Javascript.js");
        Function openChrome = this.addSeleniumFunction(functionRepository, "Open_Chrome", "java", "../data/scripts/demo-selenium-keyword.jar");
        Function googleSearch = this.addSeleniumFunction(functionRepository, "Google_Search", "java", "../data/scripts/demo-selenium-keyword.jar");
        Function googleSearchMock = this.addSeleniumFunction(functionRepository, "Google_Search_Mock", "javascript", "../data/scripts/Google_Search_Mock.js");
        Function jmeterDemoFunction = this.addJMeterFunction(functionRepository, "Demo_Keyword_JMeter", "../data/scripts/Demo_JMeter.jmx");
    }

    private CallFunction createCallFunctionByIdWithCheck(ArtefactAccessor artefacts, String functionId, String args, String check) {
        CallFunction call1 = this.createCallFunctionById(functionId, args);
        if (check != null) {
            Check check1 = new Check();
            check1.setExpression(new DynamicValue(check, ""));
            artefacts.save((AbstractArtefact)check1);
            call1.addChild(check1.getId());
        }
        artefacts.save((AbstractArtefact)call1);
        return call1;
    }

    private CallFunction createCallFunctionById(String functionId, String args) {
        CallFunction call1 = new CallFunction();
        call1.setFunctionId(functionId);
        call1.setArgument(new DynamicValue((Object)args));
        return call1;
    }

    private void createSeleniumDemoPlan(ArtefactAccessor artefacts, String browser) {
        HashMap<String, String> tcAttributes = new HashMap<String, String>();
        TestCase testCase = new TestCase();
        testCase.setRoot(true);
        tcAttributes.put("name", "Demo_Selenium_" + browser);
        testCase.setAttributes(tcAttributes);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)testCase).startBlock((AbstractArtefact)FunctionPlanBuilder.session()).add((AbstractArtefact)FunctionPlanBuilder.keyword((String)"Open_Chrome")).add((AbstractArtefact)FunctionPlanBuilder.keywordWithKeyValues((String)"Google_Search", (String[])new String[]{"search", "denkbar"})).endBlock().endBlock().build();
        LocalPlanRepository repo = new LocalPlanRepository(artefacts);
        repo.save(plan);
    }

    private Function addScriptFunction(FunctionRepositoryImpl functionRepository, String name, String scriptLanguage, String scriptFile) {
        return this.addScriptFunction(functionRepository, name, scriptLanguage, scriptFile, null);
    }

    private Function addScriptFunction(FunctionRepositoryImpl functionRepository, String name, String scriptLanguage, String scriptFile, JsonObject schema) {
        GeneralScriptFunction function = new GeneralScriptFunction();
        HashMap<String, String> kwAttributes = new HashMap<String, String>();
        kwAttributes.put("name", name);
        function.setAttributes(kwAttributes);
        function.getScriptLanguage().setValue((Object)scriptLanguage);
        function.getScriptFile().setValue((Object)scriptFile);
        if (schema != null) {
            function.setSchema(schema);
        } else {
            function.setSchema(Json.createObjectBuilder().build());
        }
        functionRepository.addFunction((Function)function);
        return function;
    }

    private Function addSeleniumFunction(FunctionRepositoryImpl functionRepository, String name, String scriptLanguage, String scriptFile) {
        SeleniumFunction function = new SeleniumFunction();
        HashMap<String, String> kwAttributes = new HashMap<String, String>();
        kwAttributes.put("name", name);
        function.setAttributes(kwAttributes);
        function.getScriptLanguage().setValue((Object)scriptLanguage);
        function.getScriptFile().setValue((Object)scriptFile);
        function.setSeleniumVersion("3.x");
        functionRepository.addFunction((Function)function);
        return function;
    }

    private Function addJMeterFunction(FunctionRepositoryImpl functionRepository, String name, String jmeterFile) {
        JMeterFunction function = new JMeterFunction();
        HashMap<String, String> kwAttributes = new HashMap<String, String>();
        kwAttributes.put("name", name);
        function.setAttributes(kwAttributes);
        function.getJmeterTestplan().setValue((Object)jmeterFile);
        functionRepository.addFunction((Function)function);
        return function;
    }
}

