/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.Promise;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;

class PromiseManager {
    private final AtomicLong index = new AtomicLong();
    private final ConcurrentHashMap<Long, Promise> registry = new ConcurrentHashMap();
    private long timeout;

    public PromiseManager(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Serializable create(LongConsumer runner) throws InterruptedException, ConnectionException, TimeoutException {
        long idx = this.index.incrementAndGet();
        try {
            Promise promise = new Promise();
            this.registry.put(idx, promise);
            runner.accept(idx);
            Object object = promise;
            synchronized (object) {
                if (this.timeout > 0L) {
                    long end = System.currentTimeMillis() + this.timeout;
                    while (promise.data == null && System.currentTimeMillis() < end) {
                        long delta = end - System.currentTimeMillis();
                        promise.wait(delta);
                    }
                } else {
                    while (promise.data == null) {
                        promise.wait();
                    }
                }
            }
            if (promise.data == null) {
                throw new TimeoutException();
            }
            if (promise.data instanceof RuntimeException) {
                throw (RuntimeException)promise.data;
            }
            if (promise.data instanceof ConnectionException) {
                throw (ConnectionException)promise.data;
            }
            if (promise.data instanceof Throwable) {
                throw new RuntimeException((Throwable)promise.data);
            }
            object = promise.data;
            return object;
        }
        finally {
            this.registry.remove(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fulfill(long idx, Serializable data) {
        Promise promise = this.registry.get(idx);
        if (promise == null) {
            return;
        }
        Promise promise2 = promise;
        synchronized (promise2) {
            promise.data = data;
            promise.notifyAll();
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

