/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelInformation;
import ch.awae.netcode.ChannelManager;
import ch.awae.netcode.ChannelUserLimitReachedException;
import ch.awae.netcode.ClientHandler;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.DuplicateUserIdException;
import ch.awae.netcode.GreetingMessage;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.MessageImpl;
import ch.awae.netcode.UserChange;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class Channel {
    private final ChannelConfiguration config;
    private final ChannelManager owner;
    private final String appId;
    private final String creator;
    private final ConcurrentHashMap<String, ClientHandler> clients = new ConcurrentHashMap();
    private final AtomicInteger memberCount = new AtomicInteger(0);
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final Lock JOIN_LOCK;
    private final Lock CLOSE_LOCK;

    Channel(String appId, ChannelConfiguration config, ChannelManager owner, String userId) {
        this.config = config;
        this.owner = owner;
        this.appId = appId;
        this.creator = userId;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.JOIN_LOCK = lock.readLock();
        this.CLOSE_LOCK = lock.writeLock();
    }

    boolean isFull() {
        return this.memberCount.get() >= this.config.getMaxClients();
    }

    void join(String userId, ClientHandler handler) throws IOException, ConnectionException, InterruptedException {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        this.JOIN_LOCK.lock();
        try {
            if (!this.open.get()) {
                throw new IllegalStateException();
            }
            if (this.memberCount.getAndIncrement() >= this.config.getMaxClients()) {
                this.memberCount.getAndDecrement();
                throw new ChannelUserLimitReachedException("channel limit reached: " + this.config.getMaxClients());
            }
            if (this.clients.putIfAbsent(userId, handler) != null) {
                this.memberCount.getAndDecrement();
                throw new DuplicateUserIdException("duplicate username: '" + userId + "'");
            }
            this.sendGreetingMessage(handler);
            this.notifyUserJoined(userId);
        }
        finally {
            this.JOIN_LOCK.unlock();
        }
    }

    void quit(String userId) throws IOException, InterruptedException {
        ClientHandler client = this.clients.remove(userId);
        if (client == null) {
            return;
        }
        client.close();
        this.send(MessageFactory.serverMessage(new UserChange(userId, false)));
        if (this.memberCount.decrementAndGet() <= 0) {
            this.owner.closeChannel(this.appId, this.config.getChannelId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException, InterruptedException {
        if (!this.open.compareAndSet(true, false)) {
            return;
        }
        this.CLOSE_LOCK.lock();
        try {
            for (String user : ((ConcurrentHashMap.CollectionView)((Object)this.clients.keySet())).toArray(new String[0])) {
                this.quit(user);
            }
        }
        finally {
            this.CLOSE_LOCK.unlock();
        }
    }

    void send(MessageImpl msg) {
        if (msg.isPrivateMessage()) {
            this.sendPrivateMessage(msg);
        } else {
            this.sendPublicMessage(msg);
        }
    }

    String[] getMembers() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.clients.keySet())).toArray(new String[0]);
    }

    ChannelInformation getInfo() {
        return new ChannelInformation(this.config.getChannelId(), this.config.getChannelName(), this.creator, this.memberCount.get(), this.config.getMaxClients(), this.config);
    }

    private void sendPrivateMessage(MessageImpl msg) {
        ClientHandler client = this.clients.get(msg.getTargetId());
        if (client != null) {
            try {
                client.send(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendPublicMessage(MessageImpl msg) {
        this.clients.values().forEach(c -> {
            if (this.config.isBounceMessages() || !c.getUserId().equals(msg.getUserId())) {
                try {
                    c.send(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void sendGreetingMessage(ClientHandler handler) throws IOException {
        String[] users = ((ConcurrentHashMap.CollectionView)((Object)this.clients.keySet())).toArray(new String[0]);
        handler.send(MessageFactory.serverMessage(new GreetingMessage(this.config, users)));
    }

    private void notifyUserJoined(String userId) {
        MessageImpl msg = MessageFactory.serverMessage(new UserChange(userId, true));
        this.clients.values().forEach(c -> {
            if (!c.getUserId().equals(userId)) {
                try {
                    c.send(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

