/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.ChannelConfiguration;
import ch.awae.netcode.ChannelManager;
import ch.awae.netcode.ClientHandler;
import ch.awae.netcode.ConnectionException;
import ch.awae.netcode.GreetingMessage;
import ch.awae.netcode.MessageFactory;
import ch.awae.netcode.MessageImpl;
import ch.awae.netcode.UserChange;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class Channel {
    private final ChannelConfiguration config;
    private final ChannelManager owner;
    private HashMap<String, ClientHandler> clients = new HashMap();
    private AtomicInteger member = new AtomicInteger(0);
    private final String appId;
    private AtomicBoolean open = new AtomicBoolean(true);

    Channel(String appId, ChannelConfiguration config, ChannelManager owner) {
        this.config = config;
        this.owner = owner;
        this.appId = appId;
    }

    synchronized void join(String userId, ClientHandler handler) throws IOException, ConnectionException {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        int count = this.member.incrementAndGet();
        if (count > this.config.getMaxClients()) {
            this.member.decrementAndGet();
            throw new ConnectionException("channel limit reached: " + this.config.getMaxClients());
        }
        ClientHandler old = this.clients.putIfAbsent(userId, handler);
        if (old != null) {
            this.member.decrementAndGet();
            throw new ConnectionException("duplicate username: '" + userId + "'");
        }
        String[] users = this.clients.keySet().toArray(new String[0]);
        handler.send(MessageFactory.serverMessage(new GreetingMessage(this.config, users)));
        this.send(MessageFactory.serverMessage(new UserChange(userId, true)));
    }

    synchronized void quit(String userId) throws IOException {
        ClientHandler client = this.clients.remove(userId);
        if (client == null) {
            return;
        }
        client.close();
        this.send(MessageFactory.serverMessage(new UserChange(userId, false)));
        if (this.member.decrementAndGet() <= 0) {
            this.owner.closeChannel(this.appId, this.config.getChannelId());
        }
    }

    synchronized void close() throws IOException {
        String[] users;
        if (!this.open.compareAndSet(true, false)) {
            return;
        }
        for (String user : users = this.clients.keySet().toArray(new String[0])) {
            this.quit(user);
        }
    }

    synchronized void send(MessageImpl msg) throws IOException {
        if (msg.isPrivateMessage()) {
            ClientHandler client = this.clients.get(msg.getTargetId());
            if (client != null) {
                client.send(msg);
            }
        } else {
            this.clients.values().forEach(c -> {
                if (this.config.isBounceMessages() || !c.getUserId().equals(msg.getUserId())) {
                    try {
                        c.send(msg);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

