/*
 * Decompiled with CFR 0.152.
 */
package ai.lucidtech.las.sdk;

import ai.lucidtech.las.sdk.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONObject;

public class Prediction {
    private String documentId;
    private String consentId;
    private String modelName;
    private List<Field> fields;

    public Prediction(String documentId, String consentId, String modelName, JSONObject predictionResponse) {
        this.documentId = documentId;
        this.consentId = consentId;
        this.modelName = modelName;
        JSONArray fields = predictionResponse.getJSONArray("predictions");
        this.fields = StreamSupport.stream(fields.spliterator(), false).map(o -> (JSONObject)o).map(Prediction::toField).collect(Collectors.toList());
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getConsentId() {
        return this.consentId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    private static Field toField(JSONObject fieldObject) {
        String label = fieldObject.getString("label");
        String value = fieldObject.getString("value");
        Float confidence = Float.valueOf(fieldObject.getFloat("confidence"));
        return new Field(label, value, confidence);
    }
}

