/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client.rpc;

import ai.grakn.client.Grakn;
import ai.grakn.client.concept.RemoteConcept;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.Graql;
import ai.grakn.graql.answer.Answer;
import ai.grakn.graql.answer.AnswerGroup;
import ai.grakn.graql.answer.ConceptList;
import ai.grakn.graql.answer.ConceptMap;
import ai.grakn.graql.answer.ConceptSet;
import ai.grakn.graql.answer.ConceptSetMeasure;
import ai.grakn.graql.answer.Value;
import ai.grakn.graql.internal.query.answer.ConceptMapImpl;
import ai.grakn.rpc.proto.AnswerProto;
import com.google.common.collect.ImmutableMap;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.stream.Collectors;

public class ResponseReader {
    public static Answer answer(AnswerProto.Answer res, Grakn.Transaction tx) {
        switch (res.getAnswerCase()) {
            case ANSWERGROUP: {
                return ResponseReader.answerGroup(res.getAnswerGroup(), tx);
            }
            case CONCEPTMAP: {
                return ResponseReader.conceptMap(res.getConceptMap(), tx);
            }
            case CONCEPTLIST: {
                return ResponseReader.conceptList(res.getConceptList());
            }
            case CONCEPTSET: {
                return ResponseReader.conceptSet(res.getConceptSet());
            }
            case CONCEPTSETMEASURE: {
                return ResponseReader.conceptSetMeasure(res.getConceptSetMeasure());
            }
            case VALUE: {
                return ResponseReader.value(res.getValue());
            }
        }
        throw new IllegalArgumentException("Unexpected " + res);
    }

    static AnswerGroup<?> answerGroup(AnswerProto.AnswerGroup res, Grakn.Transaction tx) {
        return new AnswerGroup(RemoteConcept.of(res.getOwner(), tx), res.getAnswersList().stream().map(answer -> ResponseReader.answer(answer, tx)).collect(Collectors.toList()));
    }

    static ConceptMap conceptMap(AnswerProto.ConceptMap res, Grakn.Transaction tx) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        res.getMapMap().forEach((resVar, resConcept) -> map.put((Object)Graql.var((String)resVar), (Object)RemoteConcept.of(resConcept, tx)));
        return new ConceptMapImpl((Map)map.build());
    }

    static ConceptList conceptList(AnswerProto.ConceptList res) {
        return new ConceptList(res.getList().getIdsList().stream().map(ConceptId::of).collect(Collectors.toList()));
    }

    static ConceptSet conceptSet(AnswerProto.ConceptSet res) {
        return new ConceptSet(res.getSet().getIdsList().stream().map(ConceptId::of).collect(Collectors.toSet()));
    }

    static ConceptSetMeasure conceptSetMeasure(AnswerProto.ConceptSetMeasure res) {
        return new ConceptSetMeasure(res.getSet().getIdsList().stream().map(ConceptId::of).collect(Collectors.toSet()), ResponseReader.number(res.getMeasurement()));
    }

    static Value value(AnswerProto.Value res) {
        return new Value(ResponseReader.number(res.getNumber()));
    }

    static Number number(AnswerProto.Number res) {
        try {
            return NumberFormat.getInstance().parse(res.getValue());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

