/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client.concept;

import ai.grakn.Keyspace;
import ai.grakn.client.Grakn;
import ai.grakn.client.concept.RemoteAttribute;
import ai.grakn.client.concept.RemoteAttributeType;
import ai.grakn.client.concept.RemoteEntity;
import ai.grakn.client.concept.RemoteEntityType;
import ai.grakn.client.concept.RemoteMetaType;
import ai.grakn.client.concept.RemoteRelationship;
import ai.grakn.client.concept.RemoteRelationshipType;
import ai.grakn.client.concept.RemoteRole;
import ai.grakn.client.concept.RemoteRule;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.rpc.proto.ConceptProto;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class RemoteConcept<SomeConcept extends Concept>
implements Concept {
    public static Concept of(ConceptProto.Concept concept, Grakn.Transaction tx) {
        ConceptId id = ConceptId.of((String)concept.getId());
        switch (concept.getBaseType()) {
            case ENTITY: {
                return RemoteEntity.construct(tx, id);
            }
            case RELATION: {
                return RemoteRelationship.construct(tx, id);
            }
            case ATTRIBUTE: {
                return RemoteAttribute.construct(tx, id);
            }
            case ENTITY_TYPE: {
                return RemoteEntityType.construct(tx, id);
            }
            case RELATION_TYPE: {
                return RemoteRelationshipType.construct(tx, id);
            }
            case ATTRIBUTE_TYPE: {
                return RemoteAttributeType.construct(tx, id);
            }
            case ROLE: {
                return RemoteRole.construct(tx, id);
            }
            case RULE: {
                return RemoteRule.construct(tx, id);
            }
            case META_TYPE: {
                return RemoteMetaType.construct(tx, id);
            }
        }
        throw new IllegalArgumentException("Unrecognised " + concept);
    }

    abstract Grakn.Transaction tx();

    public abstract ConceptId id();

    public final Keyspace keyspace() {
        return this.tx().keyspace();
    }

    public final void delete() throws GraknTxOperationException {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setConceptDeleteReq(ConceptProto.Concept.Delete.Req.getDefaultInstance()).build();
        this.runMethod(method);
    }

    public final boolean isDeleted() {
        return this.tx().getConcept(this.id()) == null;
    }

    protected final Stream<? extends Concept> conceptStream(int iteratorId, Function<ConceptProto.Method.Iter.Res, ConceptProto.Concept> conceptGetter) {
        Iterable iterable = () -> new Grakn.Transaction.Iterator<Concept>(this.tx(), iteratorId, res -> RemoteConcept.of((ConceptProto.Concept)conceptGetter.apply(res.getConceptMethodIterRes()), this.tx()));
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    protected final ConceptProto.Method.Res runMethod(ConceptProto.Method.Req method) {
        return this.runMethod(this.id(), method);
    }

    protected final ConceptProto.Method.Res runMethod(ConceptId id, ConceptProto.Method.Req method) {
        return this.tx().runConceptMethod(id, method).getConceptMethodRes().getResponse();
    }

    abstract SomeConcept asCurrentBaseType(Concept var1);
}

