/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client;

import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.QueryExecutor;
import ai.grakn.client.concept.RemoteConcept;
import ai.grakn.client.executor.RemoteQueryExecutor;
import ai.grakn.client.rpc.RequestBuilder;
import ai.grakn.client.rpc.ResponseReader;
import ai.grakn.client.rpc.Transceiver;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.answer.Answer;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.kb.admin.GraknAdmin;
import ai.grakn.rpc.proto.ConceptProto;
import ai.grakn.rpc.proto.KeyspaceProto;
import ai.grakn.rpc.proto.KeyspaceServiceGrpc;
import ai.grakn.rpc.proto.SessionProto;
import ai.grakn.rpc.proto.SessionServiceGrpc;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.SimpleURI;
import com.google.common.collect.AbstractIterator;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class Grakn {
    public static final SimpleURI DEFAULT_URI = new SimpleURI("localhost:48555");
    @Deprecated
    public static final SimpleURI DEFAULT_HTTP_URI = new SimpleURI("localhost:4567");
    private ManagedChannel channel;
    private KeyspaceServiceGrpc.KeyspaceServiceBlockingStub keyspaceBlockingStub;
    private Keyspace keyspace;

    public Grakn(SimpleURI uri) {
        this.channel = ManagedChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort()).usePlaintext(true).build();
        this.keyspaceBlockingStub = KeyspaceServiceGrpc.newBlockingStub((Channel)this.channel);
        this.keyspace = new Keyspace();
    }

    public Session session(ai.grakn.Keyspace keyspace) {
        return new Session(keyspace);
    }

    public Keyspace keyspaces() {
        return this.keyspace;
    }

    public static final class Transaction
    implements GraknTx,
    GraknAdmin {
        private final Session session;
        private final GraknTxType type;
        private final Transceiver transceiver;

        private Transaction(Session session, GraknTxType type) {
            this.session = session;
            this.type = type;
            this.transceiver = Transceiver.create(session.sessionStub());
            this.transceiver.send(RequestBuilder.Transaction.open(session.keyspace(), type));
            this.responseOrThrow();
        }

        public GraknAdmin admin() {
            return this;
        }

        public GraknTxType txType() {
            return this.type;
        }

        public GraknSession session() {
            return this.session;
        }

        public void close() {
            this.transceiver.close();
        }

        public boolean isClosed() {
            return this.transceiver.isClosed();
        }

        public QueryBuilder graql() {
            return new QueryBuilderImpl((GraknTx)this);
        }

        public QueryExecutor queryExecutor() {
            return RemoteQueryExecutor.create(this);
        }

        private SessionProto.Transaction.Res responseOrThrow() {
            Transceiver.Response response;
            try {
                response = this.transceiver.receive();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            switch (response.type()) {
                case OK: {
                    return response.ok();
                }
                case ERROR: {
                    throw new RuntimeException(response.error().getMessage());
                }
            }
            throw CommonUtil.unreachableStatement((String)("Unexpected response " + response));
        }

        public void commit() throws InvalidKBException {
            this.transceiver.send(RequestBuilder.Transaction.commit());
            this.responseOrThrow();
            this.close();
        }

        public java.util.Iterator query(Query<?> query) {
            this.transceiver.send(RequestBuilder.Transaction.query(query.toString(), query.inferring()));
            SessionProto.Transaction.Res txResponse = this.responseOrThrow();
            int iteratorId = txResponse.getQueryIter().getId();
            return new Iterator<Answer>(this, iteratorId, response -> ResponseReader.answer(response.getQueryIterRes().getAnswer(), this));
        }

        @Nullable
        public <T extends Type> T getType(Label label) {
            T concept = this.getSchemaConcept(label);
            if (concept == null || !concept.isType()) {
                return null;
            }
            return (T)concept.asType();
        }

        @Nullable
        public EntityType getEntityType(String label) {
            Object concept = this.getSchemaConcept(Label.of((String)label));
            if (concept == null || !concept.isEntityType()) {
                return null;
            }
            return concept.asEntityType();
        }

        @Nullable
        public RelationshipType getRelationshipType(String label) {
            Object concept = this.getSchemaConcept(Label.of((String)label));
            if (concept == null || !concept.isRelationshipType()) {
                return null;
            }
            return concept.asRelationshipType();
        }

        @Nullable
        public <V> AttributeType<V> getAttributeType(String label) {
            Object concept = this.getSchemaConcept(Label.of((String)label));
            if (concept == null || !concept.isAttributeType()) {
                return null;
            }
            return concept.asAttributeType();
        }

        @Nullable
        public Role getRole(String label) {
            Object concept = this.getSchemaConcept(Label.of((String)label));
            if (concept == null || !concept.isRole()) {
                return null;
            }
            return concept.asRole();
        }

        @Nullable
        public Rule getRule(String label) {
            Object concept = this.getSchemaConcept(Label.of((String)label));
            if (concept == null || !concept.isRule()) {
                return null;
            }
            return concept.asRule();
        }

        @Nullable
        public <T extends SchemaConcept> T getSchemaConcept(Label label) {
            this.transceiver.send(RequestBuilder.Transaction.getSchemaConcept(label));
            SessionProto.Transaction.Res response = this.responseOrThrow();
            switch (response.getGetSchemaConceptRes().getResCase()) {
                case NULL: {
                    return null;
                }
            }
            return (T)RemoteConcept.of(response.getGetSchemaConceptRes().getSchemaConcept(), this).asSchemaConcept();
        }

        @Nullable
        public <T extends Concept> T getConcept(ConceptId id) {
            this.transceiver.send(RequestBuilder.Transaction.getConcept(id));
            SessionProto.Transaction.Res response = this.responseOrThrow();
            switch (response.getGetConceptRes().getResCase()) {
                case NULL: {
                    return null;
                }
            }
            return (T)RemoteConcept.of(response.getGetConceptRes().getConcept(), this);
        }

        public <V> Collection<Attribute<V>> getAttributesByValue(V value) {
            this.transceiver.send(RequestBuilder.Transaction.getAttributes(value));
            int iteratorId = this.responseOrThrow().getGetAttributesIter().getId();
            Iterable iterable = () -> new Iterator<Concept>(this, iteratorId, response -> RemoteConcept.of(response.getGetAttributesIterRes().getAttribute(), this));
            return (Collection)StreamSupport.stream(iterable.spliterator(), false).map(Concept::asAttribute).collect(CommonUtil.toImmutableSet());
        }

        public EntityType putEntityType(Label label) {
            this.transceiver.send(RequestBuilder.Transaction.putEntityType(label));
            return RemoteConcept.of(this.responseOrThrow().getPutEntityTypeRes().getEntityType(), this).asEntityType();
        }

        public <V> AttributeType<V> putAttributeType(Label label, AttributeType.DataType<V> dataType) {
            this.transceiver.send(RequestBuilder.Transaction.putAttributeType(label, dataType));
            return RemoteConcept.of(this.responseOrThrow().getPutAttributeTypeRes().getAttributeType(), this).asAttributeType();
        }

        public RelationshipType putRelationshipType(Label label) {
            this.transceiver.send(RequestBuilder.Transaction.putRelationshipType(label));
            return RemoteConcept.of(this.responseOrThrow().getPutRelationTypeRes().getRelationType(), this).asRelationshipType();
        }

        public Role putRole(Label label) {
            this.transceiver.send(RequestBuilder.Transaction.putRole(label));
            return RemoteConcept.of(this.responseOrThrow().getPutRoleRes().getRole(), this).asRole();
        }

        public Rule putRule(Label label, Pattern when, Pattern then) {
            this.transceiver.send(RequestBuilder.Transaction.putRule(label, when, then));
            return RemoteConcept.of(this.responseOrThrow().getPutRuleRes().getRule(), this).asRule();
        }

        public Stream<SchemaConcept> sups(SchemaConcept schemaConcept) {
            ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setSchemaConceptSupsReq(ConceptProto.SchemaConcept.Sups.Req.getDefaultInstance()).build();
            SessionProto.Transaction.Res response = this.runConceptMethod(schemaConcept.id(), method);
            int iteratorId = response.getConceptMethodRes().getResponse().getSchemaConceptSupsIter().getId();
            Iterable iterable = () -> new Iterator<Concept>(this, iteratorId, res -> RemoteConcept.of(res.getConceptMethodIterRes().getSchemaConceptSupsIterRes().getSchemaConcept(), this));
            Stream sups = StreamSupport.stream(iterable.spliterator(), false);
            return Objects.requireNonNull(sups).map(Concept::asSchemaConcept);
        }

        public SessionProto.Transaction.Res runConceptMethod(ConceptId id, ConceptProto.Method.Req method) {
            SessionProto.Transaction.ConceptMethod.Req conceptMethod = SessionProto.Transaction.ConceptMethod.Req.newBuilder().setId(id.getValue()).setMethod(method).build();
            SessionProto.Transaction.Req request = SessionProto.Transaction.Req.newBuilder().setConceptMethodReq(conceptMethod).build();
            this.transceiver.send(request);
            return this.responseOrThrow();
        }

        private SessionProto.Transaction.Iter.Res iterate(int iteratorId) {
            this.transceiver.send(RequestBuilder.Transaction.iterate(iteratorId));
            return this.responseOrThrow().getIterateRes();
        }

        public static class Iterator<T>
        extends AbstractIterator<T> {
            private final int iteratorId;
            private Transaction tx;
            private Function<SessionProto.Transaction.Iter.Res, T> responseReader;

            public Iterator(Transaction tx, int iteratorId, Function<SessionProto.Transaction.Iter.Res, T> responseReader) {
                this.tx = tx;
                this.iteratorId = iteratorId;
                this.responseReader = responseReader;
            }

            protected final T computeNext() {
                SessionProto.Transaction.Iter.Res response = this.tx.iterate(this.iteratorId);
                switch (response.getResCase()) {
                    case DONE: {
                        return (T)this.endOfData();
                    }
                    case RES_NOT_SET: {
                        throw CommonUtil.unreachableStatement((String)("Unexpected " + response));
                    }
                }
                return this.responseReader.apply(response);
            }
        }
    }

    public final class Keyspace {
        public void delete(ai.grakn.Keyspace keyspace) {
            KeyspaceProto.Keyspace.Delete.Req request = RequestBuilder.Keyspace.delete(keyspace.getValue());
            Grakn.this.keyspaceBlockingStub.delete(request);
        }
    }

    public class Session
    implements GraknSession {
        private final ai.grakn.Keyspace keyspace;

        private Session(ai.grakn.Keyspace keyspace) {
            this.keyspace = keyspace;
        }

        SessionServiceGrpc.SessionServiceStub sessionStub() {
            return SessionServiceGrpc.newStub((Channel)Grakn.this.channel);
        }

        KeyspaceServiceGrpc.KeyspaceServiceBlockingStub keyspaceBlockingStub() {
            return KeyspaceServiceGrpc.newBlockingStub((Channel)Grakn.this.channel);
        }

        public Transaction transaction(GraknTxType type) {
            return new Transaction(this, type);
        }

        public void close() throws GraknTxOperationException {
            Grakn.this.channel.shutdown();
        }

        public ai.grakn.Keyspace keyspace() {
            return this.keyspace;
        }
    }
}

