/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.batch;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.batch.GraknClient;
import ai.grakn.batch.GraknClientException;
import ai.grakn.batch.QueryResponse;
import ai.grakn.graql.Query;
import ai.grakn.util.REST;
import ai.grakn.util.SimpleURI;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraknClientImpl
implements GraknClient {
    private final Logger LOG = LoggerFactory.getLogger(GraknClientImpl.class);
    private final Client client = Client.create();
    private final SimpleURI uri;

    GraknClientImpl(SimpleURI url) {
        this.client.setConnectTimeout(Integer.valueOf(30000));
        this.client.setReadTimeout(Integer.valueOf(60000));
        this.uri = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueryResponse> graqlExecute(List<Query<?>> queryList, Keyspace keyspace) throws GraknClientException {
        this.LOG.debug("Sending query list size {} to keyspace {}", (Object)queryList.size(), (Object)keyspace);
        String body = queryList.stream().map(Object::toString).reduce("; ", String::concat).substring(2);
        URI fullURI = UriBuilder.fromUri((URI)this.uri.toURI()).path(REST.resolveTemplate((String)"/kb/:keyspace/graql", (String[])new String[]{keyspace.getValue()})).queryParam("multi", new Object[]{true}).queryParam("infer", new Object[]{false}).queryParam("loading", new Object[]{true}).queryParam("txType", new Object[]{GraknTxType.BATCH}).build(new Object[0]);
        try (ClientResponse response = (ClientResponse)this.client.resource(fullURI).accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)body);){
            Response.StatusType status = response.getStatusInfo();
            String entity = (String)response.getEntity(String.class);
            if (!status.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                String queries = queryList.stream().map(Object::toString).collect(Collectors.joining("\n"));
                String error = Json.read((String)entity).at("exception").asString();
                throw new GraknClientException("Failed graqlExecute. Error status: " + status.getStatusCode() + ", error info: " + error + "\nqueries: " + queries, response.getStatusInfo());
            }
            this.LOG.debug("Received {}", (Object)status.getStatusCode());
            List<QueryResponse> list = queryList.stream().map(q -> QueryResponse.INSTANCE).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Optional<Keyspace> keyspace(String keyspace) throws GraknClientException {
        URI fullURI = UriBuilder.fromUri((URI)this.uri.toURI()).path(REST.resolveTemplate((String)"/kb/:keyspace", (String[])new String[]{keyspace})).build(new Object[0]);
        ClientResponse response = (ClientResponse)this.client.resource(fullURI).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Response.StatusType status = response.getStatusInfo();
        this.LOG.debug("Received {}", (Object)status.getStatusCode());
        if (status.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
            return Optional.empty();
        }
        String entity = (String)response.getEntity(String.class);
        if (!status.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            throw new GraknClientException("Failed keyspace. Error status: " + status.getStatusCode() + ", error info: " + entity, response.getStatusInfo());
        }
        response.close();
        return Optional.of(Keyspace.of((String)keyspace));
    }
}

