/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.exceptions;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import java.util.UUID;

public class NLApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String uuid = UUID.randomUUID().toString();
    private final NLApiErrorCode errorCode;

    public NLApiException(NLApiErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public NLApiException(NLApiErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public NLApiException(NLApiErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public NLApiException(NLApiErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    @Override
    public String getMessage() {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("error code " + this.errorCode.getErrorCode() + ": ");
        errorMessage.append(this.errorCode.getErrorMessage());
        if (super.getMessage() != null) {
            errorMessage.append(" - " + super.getMessage());
        }
        return errorMessage.toString();
    }

    public String getExceptionIdentifier() {
        return this.uuid;
    }

    public NLApiErrorCode getErrorCode() {
        return this.errorCode;
    }
}

