/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.object.ObjectService;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.wsdl11.builder.DocumentWSDL;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class WrappedWSDL
extends DocumentWSDL {
    public WrappedWSDL(ObjectService service, Collection transports) throws WSDLException {
        super(service, transports);
    }

    private QName createResponseDocumentType(Operation op, Part part) {
        ObjectService service = (ObjectService)this.getService();
        String opName = op.getName() + "Response";
        Element schemaEl = this.createSchemaType(this.getInfo().getTargetNamespace());
        Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
        schemaEl.appendChild((Node)element);
        element.addAttribute(new Attribute("name", opName));
        Element complex = new Element("xsd:complexType", "http://www.w3.org/2001/XMLSchema");
        element.appendChild((Node)complex);
        if (op.getOutParameters().size() > 0) {
            Element sequence = this.createSequence(complex);
            this.writeParametersSchema(op.getOutParameters(), sequence);
        }
        return new QName(this.getInfo().getTargetNamespace(), opName);
    }

    private QName createRequestDocumentType(Operation op, Part part) {
        ObjectService service = (ObjectService)this.getService();
        String opName = op.getName();
        Element schemaEl = this.createSchemaType(this.getInfo().getTargetNamespace());
        Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
        schemaEl.appendChild((Node)element);
        element.addAttribute(new Attribute("name", opName));
        Element complex = new Element("xsd:complexType", "http://www.w3.org/2001/XMLSchema");
        element.appendChild((Node)complex);
        if (op.getInParameters().size() > 0) {
            Element sequence = this.createSequence(complex);
            this.writeParametersSchema(op.getInParameters(), sequence);
        }
        return new QName(this.getInfo().getTargetNamespace(), opName);
    }

    private void writeParametersSchema(Collection params, Element sequence) {
        ObjectService service = (ObjectService)this.getService();
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            Parameter param = (Parameter)itr.next();
            Class clazz = param.getTypeClass();
            QName pName = param.getName();
            Type type = null;
            if (param.getAbstractType() != null) {
                type = service.getTypeMapping().getType(param.getAbstractType());
            }
            if (type == null) {
                type = service.getTypeMapping().getType(clazz);
            }
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for parameter " + param.getName());
            }
            this.addDependency(type);
            QName schemaType = type.getSchemaType();
            String uri = type.getSchemaType().getNamespaceURI();
            String prefix = this.getNamespacePrefix(uri);
            this.addNamespace(prefix, uri);
            Element outElement = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
            sequence.appendChild((Node)outElement);
            outElement.addAttribute(new Attribute("name", pName.getLocalPart()));
            outElement.addAttribute(new Attribute("type", prefix + ":" + type.getSchemaType().getLocalPart()));
            outElement.addAttribute(new Attribute("minOccurs", "1"));
            outElement.addAttribute(new Attribute("maxOccurs", "1"));
        }
    }

    private Element createSequence(Element complex) {
        Element sequence = new Element("xsd:sequence", "http://www.w3.org/2001/XMLSchema");
        complex.appendChild((Node)sequence);
        return sequence;
    }

    protected void createInputParts(Message req, Operation op) {
        Part part = this.getDefinition().createPart();
        QName typeQName = this.createRequestDocumentType(op, part);
        part.setName("parameters");
        part.setElementName(typeQName);
        req.addPart(part);
    }

    protected void createOutputParts(Message req, Operation op) {
        Part part = this.getDefinition().createPart();
        QName typeQName = this.createResponseDocumentType(op, part);
        part.setElementName(typeQName);
        part.setName("parameters");
        req.addPart(part);
    }
}

