/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderInfo;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Document;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;
import org.codehaus.yom.Serializer;
import org.codehaus.yom.converters.DOMConverter;

public abstract class AbstractWSDL
implements WSDLWriter {
    private Definition def;
    private String targetNamespace;
    private Service service;
    private Document wsdlDocument;
    private Map dependencies = new HashMap();
    private Element schemaTypes;
    private Map typeMap;
    private WSDLBuilderInfo info;
    protected static final String schemaQ = "xsd:schema";
    protected static final String elementQ = "xsd:element";
    protected static final String complexQ = "xsd:complexType";
    protected static final String sequenceQ = "xsd:sequence";

    public AbstractWSDL(Service service) throws WSDLException {
        this.service = service;
        this.info = (WSDLBuilderInfo)service.getProperty(WSDLBuilderInfo.KEY);
        if (this.info == null) {
            this.info = new WSDLBuilderInfo(service);
        }
        this.setDefinition(WSDLFactory.newInstance().newDefinition());
        this.getDefinition().setTargetNamespace(this.info.getTargetNamespace());
        Element root = new Element("root");
        Document paramDoc = new Document(root);
        this.setSchemaTypes(root);
        root.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("soap", service.getSoapVersion().getNamespace());
        this.addNamespace("soapenc", service.getSoapVersion().getSoapEncodingStyle());
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.addNamespace("tns", this.info.getTargetNamespace());
        this.typeMap = new HashMap();
    }

    protected void writeDocument() throws WSDLException {
        org.w3c.dom.Document doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.def);
        this.wsdlDocument = DOMConverter.convert((org.w3c.dom.Document)doc);
        this.writeComplexTypes();
    }

    protected void writeComplexTypes() throws WSDLException {
        Element rootEl = this.getDocument().getRootElement();
        Element types = new Element("wsdl:types", "http://schemas.xmlsoap.org/wsdl/");
        rootEl.insertChild((Node)types, 0);
        Iterator nsItr = this.typeMap.keySet().iterator();
        while (nsItr.hasNext()) {
            String schemaNs = (String)nsItr.next();
            List schemaTypes = (List)this.typeMap.get(schemaNs);
            if (schemaTypes.size() <= 0) continue;
            Element schema = new Element(schemaQ, "http://www.w3.org/2001/XMLSchema");
            types.appendChild((Node)schema);
            schema.addAttribute(new Attribute("targetNamespace", schemaNs));
            schema.addAttribute(new Attribute("elementFormDefault", "qualified"));
            schema.addAttribute(new Attribute("attributeFormDefault", "qualified"));
            this.writeSchemaForNamespace(schema, schemaNs, schemaTypes);
        }
    }

    public void addDependency(SchemaType type) {
        Set deps;
        if (!type.isComplex()) {
            return;
        }
        if (!this.dependencies.containsKey(type.getSchemaType())) {
            this.dependencies.put(type.getSchemaType(), type);
            Element e = this.createSchemaType(type.getSchemaType().getNamespaceURI());
            type.writeSchema(e);
        }
        if ((deps = type.getDependencies()) != null) {
            Iterator itr = deps.iterator();
            while (itr.hasNext()) {
                this.addDependency((SchemaType)itr.next());
            }
        }
    }

    protected void writeSchemaForNamespace(Element schema, String schemaNs, List types) {
        Iterator itr = types.iterator();
        while (itr.hasNext()) {
            Element el = (Element)itr.next();
            for (int i = 0; i < el.getChildCount(); ++i) {
                Node n = el.getChild(i);
                n.detach();
                schema.appendChild(n);
            }
            String prefix = NamespaceHelper.getUniquePrefix((Element)el, (String)schemaNs);
            String declaredUri = this.getDocument().getRootElement().getNamespaceURI(prefix);
            if (declaredUri != null) continue;
            this.getDocument().getRootElement().addNamespaceDeclaration(prefix, schemaNs);
        }
    }

    public void write(OutputStream out) throws IOException {
        Serializer writer = new Serializer(out);
        writer.write(this.getDocument());
        writer.flush();
    }

    public void addNamespace(String prefix, String uri) {
        this.def.addNamespace(prefix, uri);
        String declaredUri = this.schemaTypes.getNamespaceURI(prefix);
        if (declaredUri == null) {
            this.schemaTypes.addNamespaceDeclaration(prefix, uri);
        } else if (!declaredUri.equals(uri)) {
            throw new XFireRuntimeException("Namespace conflict: " + declaredUri + " was declared but " + uri + " was attempted.");
        }
    }

    public String getNamespacePrefix(String uri) {
        return NamespaceHelper.getUniquePrefix((Element)this.schemaTypes, (String)uri);
    }

    public WSDLBuilderInfo getInfo() {
        return this.info;
    }

    public Document getDocument() {
        return this.wsdlDocument;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public void setDefinition(Definition definition) {
        this.def = definition;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Element createSchemaType(String namespace) {
        Element e = new Element("xfiretemp");
        this.getSchemaTypes().appendChild((Node)e);
        ArrayList<Element> types = (ArrayList<Element>)this.typeMap.get(namespace);
        if (types == null) {
            types = new ArrayList<Element>();
            this.typeMap.put(namespace, types);
        }
        types.add(e);
        return e;
    }

    protected Element getSchemaTypes() {
        return this.schemaTypes;
    }

    protected void setSchemaTypes(Element schemaTypes) {
        this.schemaTypes = schemaTypes;
    }
}

