/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Service;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.object.DefaultObjectService;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.type.TypeMapping;
import org.codehaus.xfire.wsdl11.WSDLVisitor;

public class ObjectServiceVisitor
extends WSDLVisitor {
    private DefaultObjectService service;
    private TypeMapping typeMappings;
    private Map parameterMap;
    private Map typeMap;

    public ObjectServiceVisitor(Definition definition, DefaultObjectService service) {
        super(definition);
        this.service = service;
        service.setAutoTyped(true);
        service.setStyle("document");
        service.setUse("literal");
        this.typeMappings = service.getTypeMapping();
        this.parameterMap = new HashMap();
        this.typeMap = new HashMap();
    }

    public void configure() {
        this.walkTree();
    }

    protected void visit(Part part) {
        Type type = this.typeMappings.getType(part.getElementName());
        if (type == null) {
            throw new XFireRuntimeException("Couldn't find type for " + part.getElementName());
        }
        Parameter parameter = new Parameter(part.getElementName(), type.getTypeClass());
        this.parameterMap.put(part, parameter);
        this.typeMap.put(part, type.getTypeClass());
    }

    protected void visit(Operation wsdlOperation) {
        Part part;
        Method method = this.getMethod(wsdlOperation);
        org.codehaus.xfire.service.object.Operation xfireOperation = new org.codehaus.xfire.service.object.Operation(method);
        Collection inParts = wsdlOperation.getInput().getMessage().getParts().values();
        Iterator iterator = inParts.iterator();
        while (iterator.hasNext()) {
            part = (Part)iterator.next();
            Parameter inParameter = (Parameter)this.parameterMap.get(part);
            xfireOperation.addInParameter(inParameter);
        }
        Iterator outParts = wsdlOperation.getOutput().getMessage().getParts().values().iterator();
        if (outParts.hasNext()) {
            part = (Part)outParts.next();
            Parameter outParameter = (Parameter)this.parameterMap.get(part);
            xfireOperation.addOutParameter(outParameter);
        }
        this.service.addOperation(xfireOperation);
    }

    private Method getMethod(Operation wsdlOperation) {
        Input input = wsdlOperation.getInput();
        List parts = input.getMessage().getOrderedParts(wsdlOperation.getParameterOrdering());
        Class[] types = new Class[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            types[i] = (Class)this.typeMap.get((Part)parts.get(i));
        }
        try {
            return this.service.getServiceClass().getMethod(wsdlOperation.getName(), types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("There is no method matching the operation named " + wsdlOperation.getName());
        }
    }

    protected void visit(Service wsdlService) {
        this.service.setDefaultNamespace(wsdlService.getQName().getNamespaceURI());
        this.service.setName(wsdlService.getQName().getLocalPart());
    }
}

