/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.type.basic;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;

public class TypeInfo {
    private Map qname2name = new HashMap();
    private Class typeClass;
    private List attributes = new ArrayList();
    private List elements = new ArrayList();
    private String defaultNamespace;
    private QName schemaType;
    private PropertyDescriptor[] descriptors;
    static /* synthetic */ Class class$java$lang$Object;

    public TypeInfo(Class typeClass, QName complexType) {
        this.typeClass = typeClass;
        this.defaultNamespace = complexType.getNamespaceURI();
        this.initializeProperties();
    }

    protected TypeInfo(Class typeClass) {
        this.typeClass = typeClass;
        this.initializeProperties();
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public void initialize() {
        try {
            for (int i = 0; i < this.descriptors.length; ++i) {
                String name = this.descriptors[i].getName();
                if (this.isAttribute(this.descriptors[i])) {
                    this.mapAttribute(name, this.createQName(this.descriptors[i]));
                    continue;
                }
                if (!this.isElement(this.descriptors[i])) continue;
                this.mapElement(name, this.createQName(this.descriptors[i]));
            }
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't create TypeInfo.", (Throwable)e);
        }
    }

    protected QName createQName(PropertyDescriptor desc) {
        return new QName(this.defaultNamespace, desc.getName());
    }

    public void mapAttribute(String property, QName type) {
        this.qname2name.put(type, property);
        this.attributes.add(type);
    }

    public void mapElement(String property, QName type) {
        this.qname2name.put(type, property);
        this.elements.add(type);
    }

    private void initializeProperties() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = this.typeClass.isInterface() ? Introspector.getBeanInfo(this.typeClass) : Introspector.getBeanInfo(this.typeClass, class$java$lang$Object == null ? (class$java$lang$Object = TypeInfo.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (IntrospectionException e) {
            throw new XFireRuntimeException("Couldn't introspect interface.", (Throwable)e);
        }
        this.descriptors = beanInfo.getPropertyDescriptors();
        if (this.descriptors == null) {
            this.descriptors = new PropertyDescriptor[0];
        }
    }

    public PropertyDescriptor getPropertyDescriptor(QName name) {
        String propName = this.getPropertyName(name);
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!this.descriptors[i].getName().equals(propName)) continue;
            return this.descriptors[i];
        }
        return null;
    }

    protected boolean isAttribute(PropertyDescriptor desc) {
        return false;
    }

    protected boolean isElement(PropertyDescriptor desc) {
        return true;
    }

    protected boolean isSerializable(PropertyDescriptor desc) {
        return true;
    }

    protected Class getTypeClass() {
        return this.typeClass;
    }

    public boolean isNillable(QName name) {
        return true;
    }

    private String getPropertyName(QName name) {
        return (String)this.qname2name.get(name);
    }

    public Iterator getAttributes() {
        return this.attributes.iterator();
    }

    public Iterator getElements() {
        return this.elements.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

