/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.type.basic;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.message.MessageWriter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.type.basic.TypeInfo;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class BeanType
extends Type {
    private static Map objectProperties = null;
    private TypeInfo info;

    public BeanType() {
    }

    public BeanType(TypeInfo info) {
        this.info = info;
        this.setTypeClass(info.getTypeClass());
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        TypeInfo info = this.getTypeInfo();
        try {
            Object writeObj;
            Type type;
            QName name;
            MessageReader childReader;
            Class clazz = this.getTypeClass();
            Object object = clazz.newInstance();
            while (reader.hasMoreAttributeReaders()) {
                childReader = reader.getNextAttributeReader();
                name = childReader.getName();
                type = this.getType(name);
                if (type == null) continue;
                writeObj = type.readObject(childReader, context);
                this.writeProperty(name, object, writeObj);
            }
            while (reader.hasMoreElementReaders()) {
                childReader = reader.getNextElementReader();
                name = childReader.getName();
                type = this.getType(name);
                if (type != null) {
                    writeObj = type.readObject(childReader, context);
                    this.writeProperty(name, object, writeObj);
                    continue;
                }
                this.readToEnd(childReader);
            }
            return object;
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Illegal access.", (Throwable)e, "Receiver");
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate service.", (Throwable)e, "Sender");
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected void writeProperty(QName name, Object object, Object property) throws XFireFault {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptor(name);
            desc.getWriteMethod().invoke(object, property);
        }
        catch (Exception e) {
            throw new XFireFault("Couldn't set property " + name, (Throwable)e, "Sender");
        }
    }

    protected Type getType(QName name) {
        Type type = this.getTypeMapping().getType(name);
        if (type == null) {
            PropertyDescriptor desc = null;
            try {
                desc = this.getTypeInfo().getPropertyDescriptor(name);
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't get properties.", (Throwable)e);
            }
            if (desc == null) {
                return null;
            }
            type = this.getTypeMapping().getType(desc.getPropertyType());
        }
        if (type == null) {
            throw new XFireRuntimeException("Couldn't find type for property " + name);
        }
        return type;
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        MessageWriter cwriter;
        Type type;
        Object value;
        QName name;
        if (object == null) {
            return;
        }
        TypeInfo info = this.getTypeInfo();
        Iterator itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            value = this.readProperty(object, name);
            if (value == null) continue;
            type = this.getTypeMapping().getType(value.getClass());
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + value.getClass() + " for property " + name);
            }
            cwriter = writer.getAttributeWriter(name);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        }
        itr = info.getElements();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            value = this.readProperty(object, name);
            if (value == null) continue;
            type = this.getTypeMapping().getType(value.getClass());
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + value.getClass() + " for property " + name);
            }
            cwriter = writer.getElementWriter(name);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        }
    }

    protected Object readProperty(Object object, QName name) {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptor(name);
            return desc.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't get property " + name);
        }
    }

    public void writeSchema(Element root) {
        String prefix;
        Type type;
        Element element;
        QName name;
        TypeInfo info = this.getTypeInfo();
        Element complex = new Element("xsd:complexType", "http://www.w3.org/2001/XMLSchema");
        complex.addAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.appendChild((Node)complex);
        Element seq = null;
        Iterator itr = info.getElements();
        while (itr.hasNext()) {
            if (seq == null) {
                seq = new Element("xsd:sequence", "http://www.w3.org/2001/XMLSchema");
                complex.appendChild((Node)seq);
            }
            name = (QName)itr.next();
            element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
            seq.appendChild((Node)element);
            type = this.getType(name);
            prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)type.getSchemaType().getNamespaceURI());
            this.writeTypeReference(name, element, type, prefix);
        }
        itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            element = new Element("xsd:attribute", "http://www.w3.org/2001/XMLSchema");
            complex.appendChild((Node)element);
            type = this.getType(name);
            prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)type.getSchemaType().getNamespaceURI());
            element.addAttribute(new Attribute("name", name.getLocalPart()));
            element.addAttribute(new Attribute("type", prefix + ":" + type.getSchemaType().getLocalPart()));
            if (!info.isNillable(name)) continue;
            element.addAttribute(new Attribute("nillable", "true"));
        }
    }

    private void writeTypeReference(QName name, Element element, Type type, String prefix) {
        if (type.isAbstract()) {
            element.addAttribute(new Attribute("name", name.getLocalPart()));
            element.addAttribute(new Attribute("type", prefix + ":" + type.getSchemaType().getLocalPart()));
            if (this.info.isNillable(name)) {
                element.addAttribute(new Attribute("nillable", "true"));
            }
        } else {
            element.addAttribute(new Attribute("ref", prefix + ":" + type.getSchemaType().getLocalPart()));
        }
    }

    public boolean isComplex() {
        return true;
    }

    public Set getDependencies() {
        QName name;
        HashSet<Type> deps = new HashSet<Type>();
        TypeInfo info = this.getTypeInfo();
        Iterator itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            deps.add(this.getType(name));
        }
        itr = info.getElements();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            deps.add(this.getType(name));
        }
        return deps;
    }

    public TypeInfo getTypeInfo() {
        if (this.info == null) {
            this.info = this.createTypeInfo();
        }
        return this.info;
    }

    public TypeInfo createTypeInfo() {
        TypeInfo info = new TypeInfo(this.getTypeClass(), this.getSchemaType());
        info.initialize();
        return info;
    }
}

