/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.type.basic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.message.MessageWriter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class ArrayType
extends Type {
    private QName componentName;

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        try {
            Type compType = this.getComponentType();
            ArrayList<Object> values = new ArrayList<Object>();
            while (reader.hasMoreElementReaders()) {
                values.add(compType.readObject(reader.getNextElementReader(), context));
            }
            return values.toArray((Object[])Array.newInstance(compType.getTypeClass(), values.size()));
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        if (object == null) {
            return;
        }
        try {
            Object[] array = (Object[])object;
            Type type = this.getComponentType();
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + type.getTypeClass() + ".");
            }
            for (int i = 0; i < array.length; ++i) {
                String ns = null;
                ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                MessageWriter cwriter = writer.getElementWriter(type.getSchemaType().getLocalPart(), ns);
                type.writeObject(array[i], writer, context);
                cwriter.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public void writeSchema(Element root) {
        try {
            Element complex = new Element("xsd:complexType", "http://www.w3.org/2001/XMLSchema");
            complex.addAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
            root.appendChild((Node)complex);
            Element seq = new Element("xsd:sequence", "http://www.w3.org/2001/XMLSchema");
            complex.appendChild((Node)seq);
            Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
            seq.appendChild((Node)element);
            Type componentType = this.getComponentType();
            String prefix = NamespaceHelper.getUniquePrefix((Element)((Element)root.getParent()), (String)componentType.getSchemaType().getNamespaceURI());
            String typeName = prefix + ":" + componentType.getSchemaType().getLocalPart();
            element.addAttribute(new Attribute("name", componentType.getSchemaType().getLocalPart()));
            element.addAttribute(new Attribute("type", typeName));
            element.addAttribute(new Attribute("nillable", "true"));
            element.addAttribute(new Attribute("minOccurs", "0"));
            element.addAttribute(new Attribute("maxOccurs", "unbounded"));
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", (Throwable)e);
        }
    }

    public boolean isComplex() {
        return true;
    }

    public QName getComponentName() {
        return this.componentName;
    }

    public void setComponentName(QName componentName) {
        this.componentName = componentName;
    }

    public Set getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getComponentType());
        return deps;
    }

    protected Type getComponentType() {
        Class<?> compType = this.getTypeClass().getComponentType();
        if (this.componentName == null) {
            return this.getTypeMapping().getType(compType);
        }
        return this.getTypeMapping().getType(this.componentName);
    }
}

