/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.message.stax;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.message.AbstractMessageReader;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.message.stax.AttributeReader;
import org.codehaus.xfire.util.DepthXMLStreamReader;

public class ElementReader
extends AbstractMessageReader
implements MessageReader {
    private DepthXMLStreamReader root;
    private StringBuffer value;
    private String localName;
    private QName name;
    private boolean hasCheckedChildren = false;
    private boolean hasChildren = false;
    private boolean hasFoundText = false;
    private String namespace;
    private int depth;
    private int currentAttribute = 0;

    public ElementReader(DepthXMLStreamReader root) {
        this.root = root;
        this.localName = root.getLocalName();
        this.name = root.getName();
        this.namespace = root.getNamespaceURI();
        this.depth = root.getDepth();
    }

    public ElementReader(XMLStreamReader reader) {
        this.root = new DepthXMLStreamReader(reader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.namespace = this.root.getNamespaceURI();
        this.depth = this.root.getDepth();
    }

    public ElementReader(InputStream is) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = factory.createXMLStreamReader(is);
        while (xmlReader.getEventType() != 1) {
            xmlReader.next();
        }
        this.root = new DepthXMLStreamReader(xmlReader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.namespace = this.root.getNamespaceURI();
        this.depth = this.root.getDepth();
    }

    public String getValue() {
        while (!this.hasFoundText && this.checkHasMoreChildReaders()) {
        }
        if (this.value == null) {
            return null;
        }
        return this.value.toString().trim();
    }

    public String getValue(String ns, String attr) {
        return this.root.getAttributeValue(ns, attr);
    }

    public boolean hasMoreElementReaders() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        return this.hasChildren;
    }

    private boolean checkHasMoreChildReaders() {
        try {
            int event = this.root.getEventType();
            while (true) {
                switch (event) {
                    case 1: {
                        if (this.root.getDepth() <= this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = true;
                        return true;
                    }
                    case 2: {
                        if (this.root.getDepth() > this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        this.root.next();
                        return false;
                    }
                    case 4: {
                        if (this.value == null) {
                            this.value = new StringBuffer();
                        }
                        this.value.append(this.root.getText());
                        this.hasFoundText = true;
                        break;
                    }
                    case 8: {
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        return false;
                    }
                }
                event = this.root.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error parsing document.", (Throwable)e);
        }
    }

    public MessageReader getNextElementReader() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        if (!this.hasChildren) {
            return null;
        }
        this.hasCheckedChildren = false;
        return new ElementReader(this.root);
    }

    public QName getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.root;
    }

    public boolean hasMoreAttributeReaders() {
        return this.currentAttribute < this.root.getAttributeCount();
    }

    public MessageReader getNextAttributeReader() {
        AttributeReader reader = new AttributeReader(this.root.getAttributeName(this.currentAttribute), this.root.getAttributeValue(this.currentAttribute));
        ++this.currentAttribute;
        return reader;
    }
}

