/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Scanner;
import uk.modl.extractors.StarLoadExtractor;
import uk.modl.interpreter.Interpreter;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.model.Structure;
import uk.modl.parser.errors.StarLoadException;
import uk.modl.transforms.ReferencesTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.SimpleCache;

public class StarLoadTransform {
    private static final SimpleCache<String, Modl> cache = new SimpleCache();

    private static Vector<StarLoadExtractor.LoadSet> extractFilenamesAndPairs(Pair p) {
        return new StarLoadExtractor().accept(p).getLoadSets();
    }

    private Tuple2<TransformationContext, Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>>> convertFilesToModlObjectsAndPairs(TransformationContext ctx, Vector<StarLoadExtractor.LoadSet> list) {
        TransformationContext newCtx = ctx;
        IndexedSeq result = Vector.empty();
        for (StarLoadExtractor.LoadSet loadSet : list) {
            if (newCtx.isStarLoadImmutable()) {
                throw new RuntimeException("Cannot load multiple files after *LOAD instruction");
            }
            if (loadSet.getPair().getKey().startsWith("*L")) {
                newCtx = newCtx.withStarLoadImmutable(true);
            }
            Vector<StarLoadExtractor.FileSpec> filenames = loadSet.getFileSet();
            for (StarLoadExtractor.FileSpec spec : filenames) {
                Tuple2<TransformationContext, Modl> interpreted;
                Interpreter interpreter = new Interpreter();
                boolean cached = cache.contains(spec.getFilename());
                try {
                    if (cached && !spec.isForceLoad()) {
                        Tuple2<StarLoadExtractor.FileSpec, Modl> cachedModl = Tuple.of(spec, cache.get(spec.getFilename()));
                        Tuple2<TransformationContext, Modl> interpreted2 = interpreter.apply(newCtx, (Modl)cachedModl._2);
                        newCtx = (TransformationContext)interpreted2._1;
                        result = result.append(Tuple.of(Vector.of(((StarLoadExtractor.FileSpec)cachedModl._1).getFilename()), Vector.of((Modl)cachedModl._2), loadSet.getPair()));
                        continue;
                    }
                    Tuple2<StarLoadExtractor.FileSpec, String> contents = this.getFileContents(spec);
                    Modl parsed = interpreter.parse(ctx, (String)contents._2);
                    interpreted = interpreter.apply(newCtx, parsed);
                    newCtx = (TransformationContext)interpreted._1;
                    result = result.append(Tuple.of(Vector.of(((StarLoadExtractor.FileSpec)contents._1).getFilename()), Vector.of((Modl)interpreted._2), loadSet.getPair()));
                    cache.put(((StarLoadExtractor.FileSpec)contents._1).getFilename(), parsed);
                }
                catch (StarLoadException e) {
                    if (cached) {
                        Tuple2<StarLoadExtractor.FileSpec, Modl> cachedModl = Tuple.of(spec, cache.get(spec.getFilename()));
                        interpreted = interpreter.apply(newCtx, (Modl)cachedModl._2);
                        newCtx = (TransformationContext)interpreted._1;
                        result = result.append(Tuple.of(Vector.of(((StarLoadExtractor.FileSpec)cachedModl._1).getFilename()), Vector.of((Modl)cachedModl._2), loadSet.getPair()));
                        continue;
                    }
                    throw e;
                }
            }
        }
        return Tuple.of(newCtx, result);
    }

    public Tuple2<StarLoadExtractor.FileSpec, String> getFileContents(StarLoadExtractor.FileSpec spec) {
        try {
            if (spec.getFilename().startsWith("http")) {
                URL url = new URL(spec.getFilename());
                return Tuple.of(spec, new Scanner(url.openStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A").next());
            }
            if (Files.exists(Paths.get(spec.getFilename(), new String[0]), new LinkOption[0])) {
                return Tuple.of(spec, String.join((CharSequence)"\n", Files.readAllLines(Paths.get(spec.getFilename(), new String[0]))));
            }
        }
        catch (Exception e) {
            throw new StarLoadException("Could not load resource: " + e.getMessage());
        }
        throw new StarLoadException("Could not load resource: " + spec.getFilename());
    }

    public Tuple2<TransformationContext, Structure> apply(TransformationContext ctx, Structure s) {
        Pair rawPair;
        TransformationContext newCtx = ctx;
        if (s instanceof Pair && StarLoadExtractor.isLoadInstruction((rawPair = (Pair)s).getKey())) {
            Tuple2<TransformationContext, Structure> refsResult = new ReferencesTransform().apply(newCtx, rawPair);
            newCtx = (TransformationContext)refsResult._1;
            Pair p = (Pair)refsResult._2;
            Tuple2<TransformationContext, Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>>> result = this.convertFilesToModlObjectsAndPairs(newCtx, StarLoadTransform.extractFilenamesAndPairs(p));
            newCtx = ((TransformationContext)result._1).addFilesLoaded((Vector<String>)((Vector)result._2).flatMap(tuple -> (Iterable)tuple._1));
            return Tuple.of(newCtx, new StarLoadMutator((Vector)result._2).accept(p, ctx));
        }
        return Tuple.of(newCtx, s);
    }

    private static class StarLoadMutator {
        private final Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>> loadedModlObjects;

        public Pair accept(Pair pair, TransformationContext ctx) {
            Option<Tuple3> maybeFoundPair = this.loadedModlObjects.findLast(tuple3 -> pair.equals(tuple3._3));
            return maybeFoundPair.map(p -> this.replace(pair, (Tuple3<Vector<String>, Vector<Modl>, Pair>)p, ctx)).getOrElse(pair);
        }

        private Pair replace(Pair p, Tuple3<Vector<String>, Vector<Modl>, Pair> replacement, TransformationContext ctx) {
            if (p.equals(replacement._3)) {
                IndexedSeq arrayItems = ((Vector)replacement._2).flatMap(m -> ((Vector)m.getStructures().filter(structure -> structure instanceof ArrayItem)).map(structure -> (ArrayItem)((Object)structure)));
                return p.with(ctx.getAncestry(), Array.of(ctx.getAncestry(), p, (Vector<ArrayItem>)arrayItems));
            }
            return p;
        }

        public StarLoadMutator(Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>> loadedModlObjects) {
            this.loadedModlObjects = loadedModlObjects;
        }
    }
}

