/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import lombok.NonNull;
import uk.modl.model.ArrayConditional;
import uk.modl.model.ArrayItem;
import uk.modl.model.Condition;
import uk.modl.model.ConditionGroup;
import uk.modl.model.ConditionOrConditionGroupInterface;
import uk.modl.model.ConditionTest;
import uk.modl.model.EqualsOperator;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.GreaterThanOperator;
import uk.modl.model.GreaterThanOrEqualsOperator;
import uk.modl.model.LessThanOperator;
import uk.modl.model.LessThanOrEqualsOperator;
import uk.modl.model.MapConditional;
import uk.modl.model.MapItem;
import uk.modl.model.NotEqualsOperator;
import uk.modl.model.NullPrimitive;
import uk.modl.model.Operator;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.Primitive;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.model.TopLevelConditional;
import uk.modl.model.TruePrimitive;
import uk.modl.model.ValueConditional;
import uk.modl.model.ValueItem;
import uk.modl.transforms.ReferencesTransform;
import uk.modl.transforms.StarLoadTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.Util;

public class ConditionalsTransform {
    private final StarLoadTransform starLoadTransform;
    private final ReferencesTransform referencesTransform;

    public Tuple2<TransformationContext, Structure> apply(TransformationContext ctx, TopLevelConditional tlc) {
        if (tlc.getTests().size() == 1) {
            if (this.evaluate(ctx, tlc.getTests().get(0))) {
                IndexedSeq<Structure> vector = Vector.empty();
                TransformationContext newCtx = ctx;
                for (Structure structure : tlc.getReturns().get(0).getStructures()) {
                    Tuple2<TransformationContext, Structure> refsResult = this.referencesTransform.apply(newCtx, structure);
                    newCtx = (TransformationContext)refsResult._1;
                    vector = vector.append((Object)((Structure)refsResult._2));
                }
                return this.getToplevelConditionalResult(newCtx, tlc, (Vector<Structure>)vector);
            }
            if (tlc.getReturns().size() > 1) {
                IndexedSeq<Structure> vector = Vector.empty();
                TransformationContext newCtx = ctx;
                for (Structure structure : tlc.getReturns().get(1).getStructures()) {
                    Tuple2<TransformationContext, Structure> refsResult = this.referencesTransform.apply(newCtx, structure);
                    newCtx = (TransformationContext)refsResult._1;
                    vector = vector.append((Object)((Structure)refsResult._2));
                }
                return this.getToplevelConditionalResult(newCtx, tlc, (Vector<Structure>)vector);
            }
        } else {
            int i = 0;
            TransformationContext newCtx = ctx;
            IndexedSeq<Structure> structures = Vector.empty();
            for (ConditionTest test : tlc.getTests()) {
                if (this.evaluate(ctx, test)) {
                    @NonNull Vector<Structure> vector = tlc.getReturns().get(i).getStructures();
                    for (Structure structure : vector) {
                        Tuple2<TransformationContext, Structure> result = this.handleNestedTopLevelConditionals(newCtx, structure);
                        newCtx = (TransformationContext)result._1;
                        Tuple2<TransformationContext, Structure> refsResult = this.referencesTransform.apply(newCtx, (Structure)result._2);
                        newCtx = (TransformationContext)refsResult._1;
                        structures = structures.append((Object)((Structure)refsResult._2));
                    }
                    newCtx = this.conditionalFileLoading(newCtx, (Vector<Structure>)structures);
                }
                ++i;
            }
            return Tuple.of(newCtx, tlc.with(ctx.getAncestry(), (Vector<Structure>)structures));
        }
        return Tuple.of(ctx, tlc);
    }

    private Tuple2<TransformationContext, Structure> getToplevelConditionalResult(TransformationContext ctx, TopLevelConditional tlc, @NonNull Vector<Structure> vector) {
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        TransformationContext newCtx = ctx;
        IndexedSeq<Structure> structures = Vector.empty();
        for (Structure structure : vector) {
            Tuple2<TransformationContext, Structure> result = this.handleNestedTopLevelConditionals(newCtx, structure);
            newCtx = (TransformationContext)result._1;
            structures = structures.append((Object)((Structure)result._2));
        }
        newCtx = this.conditionalFileLoading(newCtx, (Vector<Structure>)structures);
        return Tuple.of(newCtx, tlc.with(ctx.getAncestry(), (Vector<Structure>)structures));
    }

    private TransformationContext conditionalFileLoading(TransformationContext ctx, Vector<Structure> structures) {
        TransformationContext newCtx = ctx;
        for (Structure structure : structures) {
            Tuple2<TransformationContext, Structure> loadResult = this.starLoadTransform.apply(newCtx, structure);
            newCtx = (TransformationContext)loadResult._1;
        }
        return newCtx;
    }

    private Tuple2<TransformationContext, Structure> handleNestedTopLevelConditionals(TransformationContext ctx, Structure structure) {
        Pair p;
        PairValue value;
        if (structure instanceof TopLevelConditional) {
            return this.apply(ctx, (TopLevelConditional)structure);
        }
        if (structure instanceof Pair && (value = (p = (Pair)structure).getValue()) instanceof ValueConditional) {
            ValueConditional result = this.apply(ctx, (ValueConditional)value);
            Pair resultPair = p.with(ctx.getAncestry(), result);
            return Tuple.of(ctx, resultPair);
        }
        return Tuple.of(ctx, structure);
    }

    private boolean evaluate(TransformationContext ctx, ConditionTest test) {
        IndexedSeq partial = test.getConditions().map(cond -> this.evaluate(ctx, (Tuple2<ConditionOrConditionGroupInterface, String>)cond));
        return this.evaluate((Vector<Tuple2<Boolean, String>>)partial);
    }

    private Tuple2<Boolean, String> evaluate(TransformationContext ctx, Tuple2<ConditionOrConditionGroupInterface, String> tuple) {
        if (tuple._1 instanceof Condition) {
            return Tuple.of(this.evaluate(ctx, (Condition)tuple._1), (String)tuple._2);
        }
        return Tuple.of(this.evaluate(ctx, (ConditionGroup)tuple._1), (String)tuple._2);
    }

    private boolean evaluate(TransformationContext ctx, ConditionGroup cg) {
        IndexedSeq partial = cg.getSubConditionList().map(sc -> Tuple.of(this.evaluate(ctx, (ConditionTest)sc._1), (String)sc._2));
        return cg.isShouldNegate() != this.evaluate((Vector<Tuple2<Boolean, String>>)partial);
    }

    private boolean evaluate(Vector<Tuple2<Boolean, String>> partial) {
        boolean first = true;
        boolean result = false;
        String lastOp = null;
        for (Tuple2 tuple2 : partial) {
            if (first) {
                first = false;
                result = (Boolean)tuple2._1;
            } else {
                switch (lastOp) {
                    case "&": {
                        result = result && (Boolean)tuple2._1 != false;
                        break;
                    }
                    case "|": {
                        result = result || (Boolean)tuple2._1 != false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid operation in conditional: " + lastOp);
                    }
                }
            }
            lastOp = (String)tuple2._2;
        }
        return result;
    }

    private boolean evaluate(TransformationContext ctx, Condition c) {
        Operator op = c.getOp();
        boolean shouldNegate = c.isShouldNegate();
        Primitive lhs = c.getLhs();
        @NonNull Vector<ValueItem> values = c.getValues();
        if (this.isSingleValueConditional(op, lhs)) {
            return this.handleSingleValueConditional(ctx, c, shouldNegate, values);
        }
        if (op instanceof GreaterThanOperator) {
            return shouldNegate != Util.greaterThanAll(lhs, values);
        }
        if (op instanceof GreaterThanOrEqualsOperator) {
            return shouldNegate != Util.greaterThanOrEqualToAll(lhs, values);
        }
        if (op instanceof LessThanOperator) {
            return shouldNegate != Util.lessThanAll(lhs, values);
        }
        if (op instanceof LessThanOrEqualsOperator) {
            return shouldNegate != Util.lessThanOrEqualToAll(lhs, values);
        }
        int count = this.countMatches(c, lhs);
        if (op instanceof EqualsOperator) {
            return shouldNegate != count > 0;
        }
        if (op instanceof NotEqualsOperator) {
            return shouldNegate != (count == 0);
        }
        return shouldNegate;
    }

    private boolean isSingleValueConditional(Operator op, Primitive lhs) {
        return op == null && lhs == null || lhs.toString() == null;
    }

    private boolean handleSingleValueConditional(TransformationContext ctx, Condition c, boolean shouldNegate, @NonNull Vector<ValueItem> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return shouldNegate != values.map(v -> {
            Pair pair;
            Option<Boolean> simpleBoolean = this.maybeBoolean(v);
            if (simpleBoolean.isDefined()) {
                return simpleBoolean.get();
            }
            String key = v.toString();
            if (v instanceof StringPrimitive && (pair = this.findReferencedPair(ctx, c, key)) != null) {
                @NonNull PairValue pairValue = pair.getValue();
                Option<Boolean> simpleBoolean2 = this.maybeBoolean(pairValue);
                if (simpleBoolean2.isDefined()) {
                    return simpleBoolean2.get();
                }
                if (pairValue instanceof ValueConditional) {
                    return this.checkValueConditionalResult((ValueConditional)pairValue);
                }
                return true;
            }
            return false;
        }).getOrElse(false);
    }

    private Boolean checkValueConditionalResult(ValueConditional pairValue) {
        return pairValue.getResult().map(vcResult -> {
            Option<Boolean> simpleBoolean3 = this.maybeBoolean(vcResult);
            if (simpleBoolean3.isDefined()) {
                return simpleBoolean3.get();
            }
            return false;
        }).getOrElse(false);
    }

    private Option<Boolean> maybeBoolean(Object o) {
        if (o instanceof TruePrimitive) {
            return Option.of(Boolean.TRUE);
        }
        if (o instanceof FalsePrimitive || o instanceof NullPrimitive) {
            return Option.of(Boolean.FALSE);
        }
        return Option.none();
    }

    private Pair findReferencedPair(TransformationContext ctx, Condition c, String key) {
        return ctx.getAncestry().findReferencedPair(ctx, c, key);
    }

    private int countMatches(Condition c, ValueItem lhs) {
        return c.getValues().count(v -> {
            if (!v.toString().contains("*")) {
                return v.toString().equals(lhs.toString());
            }
            String regexStr = v.toString().replaceAll("\\*", ".*");
            return c.getLhs().toString().matches(regexStr);
        });
    }

    public ValueConditional apply(TransformationContext ctx, ValueConditional vc) {
        if (vc.getTests().size() == 1) {
            if (this.evaluate(ctx, vc.getTests().get(0))) {
                return this.handleValueConditionalTrue(ctx, vc);
            }
            return this.handleValueConditionalFalse(ctx, vc);
        }
        int i = 0;
        for (ConditionTest test : vc.getTests()) {
            if (this.evaluate(ctx, test)) {
                IndexedSeq<ValueItem> items = Vector.empty();
                for (ValueItem vi : vc.getReturns().get(i).getItems().map(nested -> this.handleNestedValueConditionals(ctx, (ValueItem)nested))) {
                    ValueItem refsResult = this.referencesTransform.apply(ctx, vi);
                    items = items.append((Object)refsResult);
                }
                return vc.with(ctx.getAncestry(), (Vector<ValueItem>)items);
            }
            ++i;
        }
        return vc;
    }

    private ValueConditional handleValueConditionalFalse(TransformationContext ctx, ValueConditional vc) {
        if (vc.getReturns().size() == 0) {
            return vc.with(ctx.getAncestry(), Vector.of(FalsePrimitive.instance));
        }
        IndexedSeq<ValueItem> items = Vector.empty();
        for (ValueItem vi : vc.getReturns().get(1).getItems().map(nested -> this.handleNestedValueConditionals(ctx, (ValueItem)nested))) {
            ValueItem refsResult = this.referencesTransform.apply(ctx, vi);
            items = items.append((Object)refsResult);
        }
        return vc.with(ctx.getAncestry(), (Vector<ValueItem>)items);
    }

    private ValueConditional handleValueConditionalTrue(TransformationContext ctx, ValueConditional vc) {
        if (vc.getReturns().size() == 0) {
            return vc.with(ctx.getAncestry(), Vector.of(TruePrimitive.instance));
        }
        IndexedSeq<ValueItem> items = Vector.empty();
        for (ValueItem vi : vc.getReturns().get(0).getItems().map(nested -> this.handleNestedValueConditionals(ctx, (ValueItem)nested))) {
            ValueItem refsResult = this.referencesTransform.apply(ctx, vi);
            items = items.append((Object)refsResult);
        }
        return vc.with(ctx.getAncestry(), (Vector<ValueItem>)items);
    }

    private ValueItem handleNestedValueConditionals(TransformationContext ctx, ValueItem vi) {
        if (vi instanceof ValueConditional) {
            return this.apply(ctx, (ValueConditional)vi);
        }
        return vi;
    }

    private ArrayItem handleNestedArrayConditionals(TransformationContext ctx, ArrayItem vi) {
        if (vi instanceof ArrayConditional) {
            return this.apply(ctx, (ArrayConditional)vi);
        }
        return vi;
    }

    private MapItem handleNestedMapConditionals(TransformationContext ctx, MapItem vi) {
        if (vi instanceof MapConditional) {
            return this.apply(ctx, (MapConditional)vi);
        }
        return vi;
    }

    public ArrayConditional apply(TransformationContext ctx, ArrayConditional ac) {
        if (ac.getTests().size() == 1) {
            if (this.evaluate(ctx, ac.getTests().get(0))) {
                if (ac.getReturns().size() == 0) {
                    return ac.with(ctx.getAncestry(), Vector.of(TruePrimitive.instance));
                }
                IndexedSeq<ArrayItem> items = Vector.empty();
                for (ArrayItem ai : ac.getReturns().get(0).getItems().map(nested -> this.handleNestedArrayConditionals(ctx, (ArrayItem)nested))) {
                    ValueItem refsResult = this.referencesTransform.apply(ctx, (ValueItem)((Object)ai));
                    items = items.append((Object)((ArrayItem)((Object)refsResult)));
                }
                return ac.with(ctx.getAncestry(), (Vector<ArrayItem>)items);
            }
            if (ac.getReturns().size() == 0) {
                return ac.with(ctx.getAncestry(), Vector.of(FalsePrimitive.instance));
            }
            IndexedSeq<ArrayItem> items = Vector.empty();
            for (ArrayItem ai : ac.getReturns().get(1).getItems().map(nested -> this.handleNestedArrayConditionals(ctx, (ArrayItem)nested))) {
                ValueItem refsResult = this.referencesTransform.apply(ctx, (ValueItem)((Object)ai));
                items = items.append((Object)((ArrayItem)((Object)refsResult)));
            }
            return ac.with(ctx.getAncestry(), (Vector<ArrayItem>)items);
        }
        int i = 0;
        for (ConditionTest test : ac.getTests()) {
            if (this.evaluate(ctx, test)) {
                IndexedSeq<ArrayItem> items = Vector.empty();
                for (ArrayItem ai : ac.getReturns().get(i).getItems().map(nested -> this.handleNestedArrayConditionals(ctx, (ArrayItem)nested))) {
                    ValueItem refsResult = this.referencesTransform.apply(ctx, (ValueItem)((Object)ai));
                    items = items.append((Object)((ArrayItem)((Object)refsResult)));
                }
                return ac.with(ctx.getAncestry(), (Vector<ArrayItem>)items);
            }
            ++i;
        }
        return ac;
    }

    public MapConditional apply(TransformationContext ctx, MapConditional mc) {
        if (mc.getTests().size() == 1) {
            if (this.evaluate(ctx, mc.getTests().get(0))) {
                if (mc.getReturns().size() == 0) {
                    return mc.with(ctx.getAncestry(), Vector.of((MapItem)((Object)TruePrimitive.instance)));
                }
                IndexedSeq<MapItem> items = Vector.empty();
                for (MapItem mi : mc.getReturns().get(0).getItems().map(nested -> this.handleNestedMapConditionals(ctx, (MapItem)nested))) {
                    ValueItem refsResult = this.referencesTransform.apply(ctx, (ValueItem)((Object)mi));
                    items = items.append((Object)((MapItem)((Object)refsResult)));
                }
                return mc.with(ctx.getAncestry(), (Vector<MapItem>)items);
            }
            if (mc.getReturns().size() == 0) {
                return mc.with(ctx.getAncestry(), Vector.of((MapItem)((Object)FalsePrimitive.instance)));
            }
            IndexedSeq<MapItem> items = Vector.empty();
            for (MapItem mi : mc.getReturns().get(1).getItems().map(nested -> this.handleNestedMapConditionals(ctx, (MapItem)nested))) {
                ValueItem refsResult = this.referencesTransform.apply(ctx, (ValueItem)((Object)mi));
                items = items.append((Object)((MapItem)((Object)refsResult)));
            }
            return mc.with(ctx.getAncestry(), (Vector<MapItem>)items);
        }
        int i = 0;
        for (ConditionTest test : mc.getTests()) {
            if (this.evaluate(ctx, test)) {
                IndexedSeq<MapItem> items = Vector.empty();
                for (MapItem mi : mc.getReturns().get(i).getItems().map(nested -> this.handleNestedMapConditionals(ctx, (MapItem)nested))) {
                    ValueItem refsResult = this.referencesTransform.apply(ctx, (ValueItem)((Object)mi));
                    items = items.append((Object)((MapItem)((Object)refsResult)));
                }
                return mc.with(ctx.getAncestry(), (Vector<MapItem>)items);
            }
            ++i;
        }
        return mc;
    }

    public ConditionalsTransform(StarLoadTransform starLoadTransform, ReferencesTransform referencesTransform) {
        this.starLoadTransform = starLoadTransform;
        this.referencesTransform = referencesTransform;
    }
}

