/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.modl.ancestry.Ancestry;
import uk.modl.model.Modl;
import uk.modl.parser.ModlParsedVisitor;
import uk.modl.parser.antlr.MODLLexer;
import uk.modl.parser.antlr.MODLParser;
import uk.modl.parser.errors.ThrowingErrorListener;

public class Parser {
    private static final Logger log = LogManager.getLogger(Parser.class);

    public Modl apply(String input, Ancestry ancestry) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
            MODLLexer lexer = new MODLLexer(CharStreams.fromStream(stream, StandardCharsets.UTF_8));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            MODLParser parser = new MODLParser(tokens);
            parser.setBuildParseTree(true);
            lexer.addErrorListener(ThrowingErrorListener.INSTANCE);
            parser.addErrorListener(ThrowingErrorListener.INSTANCE);
            MODLParser.ModlContext modlCtx = parser.modl();
            return new ModlParsedVisitor(modlCtx, ancestry).getModl();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

