/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class TestDb {
    public TestDb() {
        try {
            String DB_URL = "jdbc:h2:mem:CoffeeDB";
            Connection conn = DriverManager.getConnection("jdbc:h2:mem:CoffeeDB");
            TestDb.dropTables(conn);
            TestDb.buildCoffeeTable(conn);
            TestDb.buildCustomerTable(conn);
            TestDb.buildUnpaidOrderTable(conn);
            conn.close();
        }
        catch (Exception e) {
            System.out.println("Error Creating the Coffee Table");
            System.out.println(e.getMessage());
        }
    }

    public static void dropTables(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("DROP TABLE Unpaidorder");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP TABLE Customer");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP TABLE Coffee");
            }
            catch (SQLException sQLException) {}
        }
        catch (SQLException ex) {
            System.out.println("ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void buildCoffeeTable(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE Coffee (Description CHAR(25), ProdNum CHAR(10) NOT NULL PRIMARY KEY, Price DOUBLE, Imported BOOLEAN)");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Bolivian Dark', '14-001', 8.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Bolivian Medium', '14-002', 8.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Brazilian Dark', '15-001', 7.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Brazilian Medium', '15-002', 7.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Brazilian Decaf', '15-003', 8.55, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Central American Dark', '16-001', 9.95, false )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Central American Medium', '16-002', 9.95, false )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Sumatra Dark', '17-001', 7.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Sumatra Decaf', '17-002', 8.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Sumatra Medium', '17-003', 7.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Sumatra Organic Dark', '17-004', 11.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Kona Medium', '18-001', 18.45, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Kona Dark', '18-002', 18.45, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'French Roast Dark', '19-001', 9.65, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Galapagos Medium', '20-001', 6.85, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Guatemalan Dark', '21-001', 9.95, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Guatemalan Decaf', '21-002', 10.45, true )");
            stmt.execute("INSERT INTO Coffee VALUES ( 'Guatemalan Medium', '21-003', 9.95, true )");
        }
        catch (SQLException ex) {
            System.out.println("ERROR: " + ex.getMessage());
        }
    }

    public static void buildCustomerTable(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE Customer( CustomerNumber CHAR(10) NOT NULL PRIMARY KEY,   Name CHAR(25),  Address CHAR(25),  City CHAR(12),  State CHAR(2),  Zip CHAR(5) )");
            stmt.executeUpdate("INSERT INTO Customer VALUES('101', 'Downtown Cafe', '17 N. Main Street', 'Asheville', 'NC', '55515')");
            stmt.executeUpdate("INSERT INTO Customer VALUES('102', 'Main Street Grocery', '110 E. Main Street', 'Canton', 'NC', '55555')");
            stmt.executeUpdate("INSERT INTO Customer VALUES('103', 'The Coffee Place', '101 Center Plaza', 'Waynesville', 'NC', '55516')");
        }
        catch (SQLException ex) {
            System.out.println("ERROR: " + ex.getMessage());
        }
    }

    public static void buildUnpaidOrderTable(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE UnpaidOrder ( CustomerNumber CHAR(10) NOT NULL REFERENCES Customer(CustomerNumber),   ProdNum CHAR(10) NOT NULL REFERENCES Coffee(ProdNum),  OrderDate CHAR(10),  Quantity DOUBLE,  Cost DOUBLE )");
        }
        catch (SQLException ex) {
            System.out.println("ERROR: " + ex.getMessage());
        }
    }
}

