/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.testutil;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NanoBench {
    private static final Logger logger = Logger.getLogger(NanoBench.class.getSimpleName());
    static int[] arrayStress = new int[10000];
    private int numberOfMeasurement = 50;
    private int numberOfWarmUp = 20;
    private List<MeasureListener> listeners = new ArrayList<MeasureListener>(2);

    public NanoBench() {
        this.listeners.add(new CPUMeasure(logger));
        this.listeners.add(new MemoryUsage(logger));
    }

    public static NanoBench create() {
        return new NanoBench();
    }

    public static Logger getLogger() {
        return logger;
    }

    public NanoBench measurements(int numberOfMeasurement) {
        this.numberOfMeasurement = numberOfMeasurement;
        return this;
    }

    public NanoBench warmUps(int numberOfWarmups) {
        this.numberOfWarmUp = numberOfWarmups;
        return this;
    }

    public NanoBench cpuAndMemory() {
        this.listeners = new ArrayList<MeasureListener>(2);
        this.listeners.add(new CPUMeasure(logger));
        this.listeners.add(new MemoryUsage(logger));
        return this;
    }

    public NanoBench bytesOnly() {
        this.listeners = new ArrayList<MeasureListener>(1);
        this.listeners.add(new BytesMeasure(logger));
        return this;
    }

    public MeasureListener getCPUListener() {
        return this.listeners.get(0);
    }

    public NanoBench cpuOnly() {
        this.listeners = new ArrayList<MeasureListener>(1);
        this.listeners.add(new CPUMeasure(logger));
        return this;
    }

    public NanoBench memoryOnly() {
        this.listeners = new ArrayList<MeasureListener>(1);
        this.listeners.add(new MemoryUsage(logger));
        return this;
    }

    public double getAvgTime() {
        CPUMeasure cpuMeasure = this.getCPUMeasure();
        return cpuMeasure.getFinalAvg();
    }

    public double getTotalTime() {
        CPUMeasure cpuMeasure = this.getCPUMeasure();
        return cpuMeasure.getFinalTotal();
    }

    public double getTps() {
        CPUMeasure cpuMeasure = this.getCPUMeasure();
        return cpuMeasure.getFinalTps();
    }

    public long getMemoryBytes() {
        MemoryUsage memoryUsage = this.getMemoryUsage();
        return memoryUsage.getFinalBytes();
    }

    private MemoryUsage getMemoryUsage() {
        MeasureListener listener = null;
        for (MeasureListener ml : this.listeners) {
            if (!(ml instanceof MemoryUsage)) continue;
            listener = ml;
        }
        if (listener == null) {
            throw new RuntimeException("Can't find memory measures");
        }
        return (MemoryUsage)listener;
    }

    private CPUMeasure getCPUMeasure() {
        MeasureListener listener = null;
        for (MeasureListener ml : this.listeners) {
            if (!(ml instanceof CPUMeasure)) continue;
            listener = ml;
        }
        if (listener == null) {
            throw new RuntimeException("Can't find CPU measures");
        }
        return (CPUMeasure)listener;
    }

    public void measure(String label, Runnable task) {
        MemoryUtil.restoreJvm();
        this.doWarmup(task);
        MemoryUtil.restoreJvm();
        this.stress();
        this.doMeasure(label, task);
        this.stress();
        MemoryUtil.restoreJvm();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void stress() {
        for (int j = 0; j < 100; ++j) {
            for (int i = 1; i < arrayStress.length; ++i) {
                NanoBench.arrayStress[i] = (int)Math.round(Math.log(i));
            }
        }
    }

    private void doMeasure(String label, Runnable task) {
        for (int i = 0; i < this.numberOfMeasurement; ++i) {
            TimeMeasureProxy tmp = new TimeMeasureProxy(new MeasureState(label, this.numberOfMeasurement), task, this.listeners);
            tmp.run();
        }
    }

    private void doWarmup(Runnable task) {
        for (int i = 0; i < this.numberOfWarmUp; ++i) {
            TimeMeasureProxy tmp = new TimeMeasureProxy(new MeasureState("_warmup_", this.numberOfWarmUp), task, this.listeners);
            tmp.run();
        }
    }

    public static class MemoryUtil {
        public static void restoreJvm() {
            int maxRestoreJvmLoops = 10;
            long memUsedPrev = MemoryUtil.memoryUsed();
            for (int i = 0; i < maxRestoreJvmLoops; ++i) {
                System.runFinalization();
                System.gc();
                long memUsedNow = MemoryUtil.memoryUsed();
                if (ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount() == 0 && memUsedNow >= memUsedPrev) break;
                memUsedPrev = memUsedNow;
            }
        }

        public static long memoryUsed() {
            Runtime rt = Runtime.getRuntime();
            return rt.totalMemory() - rt.freeMemory();
        }
    }

    private static class MemoryUsage
    implements MeasureListener {
        private static final DecimalFormat integerFormat = new DecimalFormat("#,##0.000");
        private final Logger log;
        private int count = 0;
        private long memoryUsed = 0L;
        private long finalBytes;

        public MemoryUsage(Logger logger) {
            this.log = logger;
        }

        @Override
        public void onMeasure(MeasureState state) {
            ++this.count;
            this.outputMeasureInfo(state);
        }

        private void outputMeasureInfo(MeasureState state) {
            MemoryUtil.restoreJvm();
            this.memoryUsed += MemoryUtil.memoryUsed();
            if (this.isEnd(state)) {
                this.finalBytes = this.memoryUsed / (long)this.count;
                StringBuilder sb = new StringBuilder("\n");
                sb.append("memory-usage: ").append(state.getLabel()).append("\t").append(this.format((double)this.finalBytes / 1048576.0)).append(" Mb\n");
                this.count = 0;
                this.memoryUsed = 0L;
                if (!state.getLabel().equals("_warmup_")) {
                    this.log.info(sb.toString());
                }
            }
        }

        public long getFinalBytes() {
            return this.finalBytes;
        }

        private String format(double value) {
            return integerFormat.format(value);
        }

        private boolean isEnd(MeasureState state) {
            return (long)this.count == state.getMeasurements();
        }
    }

    private static class BytesMeasure
    implements MeasureListener {
        private static final DecimalFormat integerFormat = new DecimalFormat("#,##0.0");
        private final Logger log;
        private int count = 0;
        private long bytesUsed = 0L;

        public BytesMeasure(Logger logger) {
            this.log = logger;
        }

        @Override
        public void onMeasure(MeasureState state) {
            ++this.count;
            this.outputMeasureInfo(state);
        }

        private void outputMeasureInfo(MeasureState state) {
            this.bytesUsed += (long)state.getBytesMeasure();
            if (this.isEnd(state)) {
                StringBuilder sb = new StringBuilder("\n");
                sb.append("bytes-usage: ").append(state.getLabel()).append("\t").append(this.format(this.bytesUsed / (long)this.count)).append(" Bytes\t").append(this.format((double)(this.bytesUsed / (long)this.count) / 1048576.0)).append(" Mb\n");
                this.count = 0;
                this.bytesUsed = 0L;
                if (!state.getLabel().equals("_warmup_")) {
                    this.log.info(sb.toString());
                }
            }
        }

        private String format(double value) {
            return integerFormat.format(value);
        }

        private boolean isEnd(MeasureState state) {
            return (long)this.count == state.getMeasurements();
        }
    }

    public static class CPUMeasure
    implements MeasureListener {
        private static final double BY_SECONDS = 1.0E9;
        private static final DecimalFormat decimalFormat = new DecimalFormat("#,##0.0000");
        private static final DecimalFormat integerFormat = new DecimalFormat("#,##0.0");
        private final Logger log;
        private int count = 0;
        private long timeUsed = 0L;
        private double finalTps;
        private double finalAvg;
        private double finalTotal;

        public CPUMeasure(Logger logger) {
            this.log = logger;
        }

        @Override
        public void onMeasure(MeasureState state) {
            ++this.count;
            this.outputMeasureInfo(state);
        }

        private void outputMeasureInfo(MeasureState state) {
            this.timeUsed += state.getMeasureTime();
            if (this.isEnd(state)) {
                long total = this.timeUsed;
                this.finalAvg = (double)(total / state.getMeasurements()) / 1000000.0;
                this.finalTotal = (double)total / 1.0E9;
                this.finalTps = (double)state.getMeasurements() / ((double)total / 1.0E9);
                StringBuilder sb = new StringBuilder("\n");
                sb.append(state.getLabel()).append("\t").append("avg: ").append(decimalFormat.format(this.finalAvg)).append(" ms\t").append("total: ").append(integerFormat.format(this.finalTotal)).append(" s\t").append("   tps: ").append(integerFormat.format(this.finalTps)).append("\t").append("running: ").append(this.count).append(" times");
                this.count = 0;
                this.timeUsed = 0L;
                if (!state.getLabel().equals("_warmup_")) {
                    this.log.info(sb.toString());
                }
            }
        }

        public double getFinalAvg() {
            return this.finalAvg;
        }

        public double getFinalTotal() {
            return this.finalTotal;
        }

        public double getFinalTps() {
            return this.finalTps;
        }

        private boolean isEnd(MeasureState state) {
            return (long)this.count == state.getMeasurements();
        }
    }

    private static class MeasureState
    implements Comparable<MeasureState> {
        private String label;
        private long startTime;
        private long endTime;
        private int measurement;
        private int bytesMeasure;

        public MeasureState(String label, int measurement) {
            this.label = label;
            this.measurement = measurement;
        }

        public String getLabel() {
            return this.label;
        }

        public long getMeasurements() {
            return this.measurement;
        }

        public long getMeasureTime() {
            return this.endTime - this.startTime;
        }

        public void startNow() {
            this.startTime = System.nanoTime();
        }

        public void endNow() {
            this.endTime = System.nanoTime();
        }

        public int getBytesMeasure() {
            return this.bytesMeasure;
        }

        @Override
        public int compareTo(MeasureState another) {
            if (this.startTime > another.startTime) {
                return -1;
            }
            if (this.startTime < another.startTime) {
                return 1;
            }
            return 0;
        }
    }

    public static abstract class BytesRunnable
    implements Runnable {
        protected int measure;

        @Override
        public void run() {
            this.measure = this.runMeasure();
        }

        public abstract int runMeasure();

        public int getMeasure() {
            return this.measure;
        }
    }

    private static class TimeMeasureProxy
    implements Runnable {
        private MeasureState state;
        private Runnable runnable;
        private List<MeasureListener> listeners;

        public TimeMeasureProxy(MeasureState state, Runnable runnable, List<MeasureListener> listeners) {
            this.state = state;
            this.runnable = runnable;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            this.state.startNow();
            this.runnable.run();
            this.state.endNow();
            if (this.runnable instanceof BytesRunnable) {
                this.state.bytesMeasure = ((BytesRunnable)this.runnable).getMeasure();
            }
            if (!this.state.getLabel().equals("_warmup_")) {
                this.notifyMeasurement(this.state);
            }
        }

        private void notifyMeasurement(MeasureState times) {
            for (MeasureListener listener : this.listeners) {
                listener.onMeasure(times);
            }
        }
    }

    private static interface MeasureListener {
        public void onMeasure(MeasureState var1);
    }
}

