/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.reducing.NumericReduceFunction;
import tech.tablesaw.reducing.NumericSummaryTable;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;

public class ViewGroupTest {
    static NumericReduceFunction exaggerate = new NumericReduceFunction(){

        public String functionName() {
            return "exaggeration";
        }

        public double reduce(double[] data) {
            return StatUtils.max((double[])data) + 1000.0;
        }
    };
    private final ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.INTEGER, ColumnType.CATEGORY};
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(this.types));
    }

    @Test
    public void testViewGroupCreation() {
        ViewGroup group = new ViewGroup(this.table, new Column[]{this.table.column("who")});
        Assert.assertEquals((long)6L, (long)group.size());
        List viewList = group.getSubTables();
        int count = 0;
        for (TemporaryView view : viewList) {
            count += view.rowCount();
        }
        Assert.assertEquals((long)this.table.rowCount(), (long)count);
    }

    @Test
    public void testViewTwoColumn() {
        ViewGroup group = new ViewGroup(this.table, new Column[]{this.table.column("who"), this.table.column("approval")});
        List viewList = group.getSubTables();
        int count = 0;
        for (TemporaryView view : viewList) {
            count += view.rowCount();
        }
        Assert.assertEquals((long)this.table.rowCount(), (long)count);
    }

    @Test
    public void testWith2GroupingCols() {
        CategoryColumn month = this.table.dateColumn(0).month();
        month.setName("month");
        this.table.addColumn(new Column[]{month});
        String[] splitColumnNames = new String[]{this.table.column(2).name(), "month"};
        ViewGroup tableGroup = ViewGroup.create((Table)this.table, (String[])splitColumnNames);
        List tables = tableGroup.getSubTables();
        NumericSummaryTable t = this.table.sum("approval").by(splitColumnNames);
        Assert.assertEquals((long)this.table.intColumn(1).sum(), (long)Math.round(t.floatColumn(2).sum()));
        Assert.assertEquals((long)65L, (long)tables.size());
    }

    @Test
    public void testCountByGroup() {
        NumericSummaryTable groups = this.table.count("approval").by(new String[]{"who"});
        Assert.assertEquals((long)2L, (long)groups.columnCount());
        Assert.assertEquals((long)6L, (long)groups.rowCount());
        CategoryColumn group = groups.categoryColumn(0);
        Assert.assertTrue((boolean)group.contains("fox"));
    }

    @Test
    public void testCustomFunction() {
        NumericSummaryTable exaggeration = this.table.summarize("approval", exaggerate).by(new String[]{"who"});
        CategoryColumn group = exaggeration.categoryColumn(0);
        Assert.assertTrue((boolean)group.contains("fox"));
    }

    @Test
    public void testSumGroup() {
        NumericSummaryTable groups = this.table.sum("approval").by(new String[]{"who"});
        Assert.assertEquals((long)this.table.intColumn(1).sum(), (long)Math.round(groups.floatColumn(1).sum()));
    }
}

