/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.store;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.store.StorageManager;
import tech.tablesaw.table.Relation;

public class StorageManagerTest {
    private static final int COUNT = 5;
    private static final ColumnType[] COLUMN_TYPES = new ColumnType[]{ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.LOCAL_DATE, ColumnType.LOCAL_TIME, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.CATEGORY, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.FLOAT, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.CATEGORY};
    private Table table = Table.create((String)"t");
    private FloatColumn floatColumn = new FloatColumn("float");
    private CategoryColumn categoryColumn = new CategoryColumn("cat");
    private DateColumn localDateColumn = new DateColumn("date");
    private LongColumn longColumn = new LongColumn("long");

    public static void main(String[] args) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        System.out.println("loading");
        Table tornados = Table.read().csv(CsvReadOptions.builder((String)"../data/1950-2014_torn.csv").columnTypes(COLUMN_TYPES));
        tornados.setName("tornados");
        System.out.println(String.format("loaded %d records in %d seconds", tornados.rowCount(), stopwatch.elapsed(TimeUnit.SECONDS)));
        System.out.println(tornados.shape());
        System.out.println(tornados.columnNames().toString());
        System.out.println(tornados.first(10));
        stopwatch.reset().start();
        StorageManager.saveTable((String)"/tmp/tablesaw/testdata", (Relation)tornados);
        stopwatch.reset().start();
        tornados = StorageManager.readTable((String)"/tmp/tablesaw/testdata/tornados.saw");
        System.out.println(tornados.first(5));
    }

    @Before
    public void setUp() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.floatColumn.append((float)i);
            this.localDateColumn.append(LocalDate.now());
            this.categoryColumn.add("Category " + i);
            this.longColumn.append((long)i);
        }
        this.table.addColumn(new Column[]{this.floatColumn});
        this.table.addColumn(new Column[]{this.localDateColumn});
        this.table.addColumn(new Column[]{this.categoryColumn});
        this.table.addColumn(new Column[]{this.longColumn});
    }

    @Test
    public void testCatStorage() throws Exception {
        StorageManager.writeColumn((String)"/tmp/cat_dogs", (CategoryColumn)this.categoryColumn);
        CategoryColumn readCat = StorageManager.readCategoryColumn((String)"/tmp/cat_dogs", (ColumnMetadata)this.categoryColumn.columnMetadata());
        for (int i = 0; i < this.categoryColumn.size(); ++i) {
            Assert.assertEquals((Object)this.categoryColumn.get(i), (Object)readCat.get(i));
        }
    }

    @Test
    public void testWriteTable() throws IOException {
        StorageManager.saveTable((String)"/tmp/zeta", (Relation)this.table);
        Table t = StorageManager.readTable((String)"/tmp/zeta/t.saw");
        Assert.assertEquals((long)this.table.columnCount(), (long)t.columnCount());
        Assert.assertEquals((long)this.table.rowCount(), (long)t.rowCount());
        for (int i = 0; i < this.table.rowCount(); ++i) {
            Assert.assertEquals((Object)this.categoryColumn.get(i), (Object)t.categoryColumn("cat").get(i));
        }
        t.sortOn(new String[]{"cat"});
    }

    @Test
    public void testWriteTableTwice() throws IOException {
        StorageManager.saveTable((String)"/tmp/mytables2", (Relation)this.table);
        Table t = StorageManager.readTable((String)"/tmp/mytables2/t.saw");
        t.floatColumn("float").setName("a float column");
        StorageManager.saveTable((String)"/tmp/mytables2", (Relation)this.table);
        t = StorageManager.readTable((String)"/tmp/mytables2/t.saw");
        Assert.assertEquals((Object)this.table.name(), (Object)t.name());
        Assert.assertEquals((long)this.table.rowCount(), (long)t.rowCount());
        Assert.assertEquals((long)this.table.columnCount(), (long)t.columnCount());
    }

    @Test
    public void testSeparator() {
        Assert.assertNotNull((Object)StorageManager.separator());
    }
}

