/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.junit.Test;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.store.StorageManager;
import tech.tablesaw.testutil.DirectoryUtils;
import tech.tablesaw.testutil.NanoBench;

public class SnappyCompressionBenchmark {
    @Test
    public void testFloat() {
        File TEST_FOLDER = Paths.get("testfolder", new String[0]).toFile();
        Table t = Table.create((String)"Test");
        FloatColumn c = new FloatColumn("fc");
        t.addColumn(new Column[]{c});
        Path path = Paths.get("testfolder", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < 1000000; ++i) {
            c.append((float)Math.random());
        }
        NanoBench nanoBench = NanoBench.create();
        nanoBench.warmUps(5).measurements(20).cpuAndMemory().measure("Compression and file writing", () -> {
            try {
                StorageManager.writeColumn((String)(TEST_FOLDER + File.separator + "foo"), (FloatColumn)c);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        System.out.println("Compressed size: " + DirectoryUtils.folderSize(TEST_FOLDER));
    }

    @Test
    public void testInt() {
        final File TEST_FOLDER = Paths.get("testfolder", new String[0]).toFile();
        Table t = Table.create((String)"Test");
        final IntColumn c = new IntColumn("fc", 10000000);
        t.addColumn(new Column[]{c});
        RandomDataGenerator randomDataGenerator = new RandomDataGenerator();
        for (int i = 0; i < 10000000; ++i) {
            c.append(randomDataGenerator.nextInt(0, 1000000));
        }
        Path path = Paths.get("testfolder", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        NanoBench nanoBench = NanoBench.create();
        nanoBench.warmUps(5).measurements(20).cpuAndMemory().measure("Compression", new Runnable(){

            @Override
            public void run() {
                try {
                    StorageManager.writeColumn((String)(TEST_FOLDER + File.separator + "foo"), (IntColumn)c);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        System.out.println("Compressed size: " + DirectoryUtils.folderSize(TEST_FOLDER));
    }
}

