/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.reducing;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.reducing.NumericReduceUtils;
import tech.tablesaw.reducing.NumericSummaryTable;
import tech.tablesaw.table.ViewGroup;

public class NumericReduceUtilsTest {
    private static ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.INTEGER, ColumnType.CATEGORY};
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(types));
    }

    @Test
    public void testMean() {
        double result = this.table.reduce("approval", NumericReduceUtils.mean);
        Assert.assertEquals((double)64.88235294117646, (double)result, (double)0.01);
    }

    @Test
    public void testGroupMean() {
        Column byColumn = this.table.column("who");
        ViewGroup group = new ViewGroup(this.table, new Column[]{byColumn});
        NumericSummaryTable result = group.reduce("approval", NumericReduceUtils.mean);
        Assert.assertEquals((long)2L, (long)result.columnCount());
        Assert.assertEquals((Object)"who", (Object)result.column(0).name());
        Assert.assertEquals((long)6L, (long)result.rowCount());
        Assert.assertEquals((Object)"65.671875", (Object)result.get(0, 1));
    }

    @Test
    public void test2ColumnGroupMean() {
        Column byColumn1 = this.table.column("who");
        ViewGroup group = new ViewGroup(this.table, new Column[]{byColumn1});
        NumericSummaryTable result = group.reduce("approval", NumericReduceUtils.mean);
        Assert.assertEquals((long)2L, (long)result.columnCount());
        Assert.assertEquals((Object)"who", (Object)result.column(0).name());
        Assert.assertEquals((long)6L, (long)result.rowCount());
        Assert.assertEquals((Object)"65.671875", (Object)result.get(0, 1));
    }
}

