/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.junit.Assert;
import org.junit.Test;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;

public class DateTimeMapUtilsTest {
    private DateTimeColumn startCol = new DateTimeColumn("start");
    private DateTimeColumn stopCol = new DateTimeColumn("stop");
    private LocalDateTime start = LocalDateTime.now();

    @Test
    public void testDifferenceInMilliseconds() throws Exception {
        long pStart = PackedLocalDateTime.pack((LocalDateTime)this.start);
        LocalDateTime stop = this.start.plus(100000L, ChronoUnit.MILLIS);
        long pStop = PackedLocalDateTime.pack((LocalDateTime)stop);
        this.startCol.add(this.start);
        this.stopCol.add(stop);
        Assert.assertEquals((long)100000L, (long)this.startCol.difference(pStart, pStop, ChronoUnit.MILLIS));
        LongColumn result = this.startCol.differenceInMilliseconds(this.stopCol);
        Assert.assertEquals((long)100000L, (long)result.firstElement());
    }

    @Test
    public void testDifferenceInSeconds() throws Exception {
        LocalDateTime stop = this.start.plus(100000L, ChronoUnit.SECONDS);
        this.startCol.add(this.start);
        this.stopCol.add(stop);
        LongColumn result = this.startCol.differenceInSeconds(this.stopCol);
        Assert.assertEquals((long)100000L, (long)result.firstElement());
    }

    @Test
    public void testDifferenceInMinutes() throws Exception {
        LocalDateTime stop = this.start.plus(100000L, ChronoUnit.MINUTES);
        this.startCol.add(this.start);
        this.stopCol.add(stop);
        LongColumn result = this.startCol.differenceInMinutes(this.stopCol);
        Assert.assertEquals((long)100000L, (long)result.firstElement());
    }

    @Test
    public void testDifferenceInHours() throws Exception {
        LocalDateTime stop = this.start.plus(100000L, ChronoUnit.HOURS);
        this.startCol.add(this.start);
        this.stopCol.add(stop);
        LongColumn result = this.startCol.differenceInHours(this.stopCol);
        Assert.assertEquals((long)100000L, (long)result.firstElement());
    }

    @Test
    public void testDifferenceInDays() throws Exception {
        LocalDateTime stop = this.start.plus(100000L, ChronoUnit.DAYS);
        this.startCol.add(this.start);
        this.stopCol.add(stop);
        LongColumn result = this.startCol.differenceInDays(this.stopCol);
        Assert.assertEquals((long)100000L, (long)result.firstElement());
    }

    @Test
    public void testDifferenceInYears() throws Exception {
        LocalDateTime stop = this.start.plus(10000L, ChronoUnit.YEARS);
        this.startCol.add(this.start);
        this.stopCol.add(stop);
        LongColumn result = this.startCol.differenceInYears(this.stopCol);
        Assert.assertEquals((long)10000L, (long)result.firstElement());
    }

    @Test
    public void testHour() throws Exception {
        this.startCol.add(LocalDateTime.of(1984, 12, 12, 7, 30));
        ShortColumn hour = this.startCol.hour();
        Assert.assertEquals((long)7L, (long)hour.firstElement());
    }
}

