/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import java.time.LocalTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public class DateMapUtilsTest {
    private DateColumn column1;

    @Before
    public void setUp() throws Exception {
        Table table = Table.create((String)"Test");
        this.column1 = new DateColumn("Game date");
        table.addColumn(new Column[]{this.column1});
    }

    @Test
    public void testAtTimeColumn() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/24/1924");
        this.column1.appendCell("12-May-2015");
        this.column1.appendCell("14-Jan-2015");
        TimeColumn timeColumn = new TimeColumn("times");
        timeColumn.append(LocalTime.NOON);
        timeColumn.append(LocalTime.NOON);
        timeColumn.append(LocalTime.NOON);
        timeColumn.append(LocalTime.NOON);
        DateTimeColumn dateTimes = this.column1.atTime(timeColumn);
        Assert.assertNotNull((Object)dateTimes);
        Assert.assertTrue((boolean)dateTimes.get(0).toLocalTime().equals(LocalTime.NOON));
    }

    @Test
    public void testAtTime() throws Exception {
        this.column1.appendCell("2013-10-23");
        this.column1.appendCell("12/24/1924");
        this.column1.appendCell("12-May-2015");
        this.column1.appendCell("14-Jan-2015");
        DateTimeColumn dateTimes = this.column1.atTime(LocalTime.NOON);
        Assert.assertNotNull((Object)dateTimes);
        Assert.assertTrue((boolean)dateTimes.get(0).toLocalTime().equals(LocalTime.NOON));
    }
}

