/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.jdbc.SqlResultSetReader;
import tech.tablesaw.util.TestDb;

public class SqlResultSetReaderTest {
    @Test
    public void testSqlResultSetReader() throws Exception {
        String DB_URL = "jdbc:h2:mem:CoffeeDB";
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:CoffeeDB");
        TestDb.dropTables(conn);
        TestDb.buildCoffeeTable(conn);
        TestDb.buildCustomerTable(conn);
        TestDb.buildUnpaidOrderTable(conn);
        try (Statement stmt = conn.createStatement();){
            String sql = "SELECT * FROM coffee";
            try (ResultSet rs = stmt.executeQuery(sql);){
                Table coffee = SqlResultSetReader.read((ResultSet)rs, (String)"Coffee");
                Assert.assertEquals((long)4L, (long)coffee.columnCount());
                Assert.assertEquals((long)18L, (long)coffee.rowCount());
            }
            sql = "SELECT * FROM Customer";
            rs = stmt.executeQuery(sql);
            var7_9 = null;
            try {
                Table customer = SqlResultSetReader.read((ResultSet)rs, (String)"Customer");
                Assert.assertEquals((long)6L, (long)customer.columnCount());
                Assert.assertEquals((long)3L, (long)customer.rowCount());
            }
            catch (Throwable customer) {
                var7_9 = customer;
                throw customer;
            }
            finally {
                if (rs != null) {
                    if (var7_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable customer) {
                            var7_9.addSuppressed(customer);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            sql = "SELECT * FROM UnpaidOrder";
            rs = stmt.executeQuery(sql);
            var7_9 = null;
            try {
                Table unpaidInvoice = SqlResultSetReader.read((ResultSet)rs, (String)"Unpaid Invoice");
                Assert.assertEquals((long)5L, (long)unpaidInvoice.columnCount());
                Assert.assertEquals((long)0L, (long)unpaidInvoice.rowCount());
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var7_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }
}

