/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;

public class CsvReaderTest {
    private final ColumnType[] bus_types = new ColumnType[]{ColumnType.SHORT_INT, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.FLOAT, ColumnType.FLOAT};
    private final ColumnType[] bus_types_with_SKIP = new ColumnType[]{ColumnType.SHORT_INT, ColumnType.CATEGORY, ColumnType.SKIP, ColumnType.FLOAT, ColumnType.FLOAT};

    @Test
    public void testWithBusData() throws Exception {
        Table table = Table.read().csv(CsvReadOptions.builder((String)"../data/bus_stop_test.csv").columnTypes(this.bus_types));
        Assert.assertEquals((Object)"[stop_id, stop_name, stop_desc, stop_lat, stop_lon]", (Object)table.columnNames().toString());
        table = table.sortDescendingOn(new String[]{"stop_id"});
        table.removeColumns(new String[]{"stop_desc"});
    }

    @Test
    public void testWithColumnSKIP() throws Exception {
        Table table = Table.read().csv(CsvReadOptions.builder((String)"../data/bus_stop_test.csv").columnTypes(this.bus_types_with_SKIP));
        Assert.assertEquals((long)4L, (long)table.columnCount());
        Assert.assertEquals((Object)"[stop_id, stop_name, stop_lat, stop_lon]", (Object)table.columnNames().toString());
    }

    @Test
    public void testWithBushData() throws Exception {
        ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.SHORT_INT, ColumnType.CATEGORY};
        Table table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(types));
        Assert.assertEquals((long)323L, (long)table.rowCount());
        Assert.assertEquals((Object)"[date, approval, who]", (Object)table.columnNames().toString());
    }

    @Test
    public void testBushDataWithoutSamplingForTypeDetection() throws Exception {
        Table table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").sample(false));
        Assert.assertEquals((long)323L, (long)table.rowCount());
        Assert.assertEquals((Object)"[date, approval, who]", (Object)table.columnNames().toString());
    }

    @Test
    public void testDataTypeDetection() throws Exception {
        FileInputStream stream = new FileInputStream(new File("../data/bus_stop_test.csv"));
        Object[] columnTypes = CsvReader.detectColumnTypes((InputStream)stream, (boolean)true, (char)',', (boolean)false);
        Assert.assertTrue((boolean)Arrays.equals(this.bus_types, columnTypes));
    }

    @Test
    public void testPrintStructure() throws Exception {
        String output = "ColumnType[] columnTypes = {\nLOCAL_DATE, // 0     date        \nSHORT_INT,  // 1     approval    \nCATEGORY,   // 2     who         \n}\n";
        Assert.assertEquals((Object)output, (Object)CsvReader.printColumnTypes((String)"../data/BushApproval.csv", (boolean)true, (char)','));
    }

    @Test
    public void testDataTypeDetection2() throws Exception {
        FileInputStream stream = new FileInputStream(new File("../data/BushApproval.csv"));
        ColumnType[] columnTypes = CsvReader.detectColumnTypes((InputStream)stream, (boolean)true, (char)',', (boolean)false);
        Assert.assertEquals((Object)ColumnType.LOCAL_DATE, (Object)columnTypes[0]);
        Assert.assertEquals((Object)ColumnType.SHORT_INT, (Object)columnTypes[1]);
        Assert.assertEquals((Object)ColumnType.CATEGORY, (Object)columnTypes[2]);
    }

    @Ignore
    @Test
    public void testLoadFromUrl() throws Exception {
        Table table;
        ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.SHORT_INT, ColumnType.CATEGORY};
        String location = "https://raw.githubusercontent.com/jtablesaw/tablesaw/master/data/BushApproval.csv";
        try (InputStream input = new URL(location).openStream();){
            table = Table.read().csv(CsvReadOptions.builder((InputStream)input, (String)"Bush approval ratings").columnTypes(types));
        }
        Assert.assertNotNull((Object)table);
    }

    @Test
    public void testBoundary1() throws Exception {
        Table table1 = Table.read().csv("../data/boundaryTest1.csv");
        table1.structure();
    }

    @Test
    public void testBoundary2() throws Exception {
        Table table1 = Table.read().csv("../data/boundaryTest2.csv");
        table1.structure();
    }

    @Test
    public void testReadFailure() throws Exception {
        Table table1 = Table.read().csv("../data/read_failure_test.csv");
        table1.structure();
        ShortColumn test = table1.shortColumn("Test");
        Assert.assertNotNull((Object)test.summary());
    }

    @Test
    public void testReadFailure2() throws Exception {
        Table table1 = Table.read().csv("../data/read_failure_test2.csv");
        table1.structure();
        ShortColumn test = table1.shortColumn("Test");
        Assert.assertNotNull((Object)test.summary());
    }
}

