/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.integration;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.QueryHelper;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvWriter;

public class ExamplesTest {
    public static void main(String[] args) throws Exception {
        ExamplesTest.out("");
        ExamplesTest.out("Some Examples: ");
        ColumnType[] types = new ColumnType[]{ColumnType.INTEGER, ColumnType.CATEGORY, ColumnType.CATEGORY, ColumnType.FLOAT, ColumnType.FLOAT};
        Table table = Table.read().csv(CsvReadOptions.builder((String)"../data/bus_stop_test.csv").columnTypes(types));
        ExamplesTest.out(table.columnNames());
        ExamplesTest.out(table.first(5));
        table.removeColumns(new String[]{"stop_desc"});
        ExamplesTest.out(table.columnNames());
        ExamplesTest.out("In 'examples. Printing first(5)");
        ExamplesTest.out(table.first(5));
        ExamplesTest.out(table.floatColumn("stop_lat").summary());
        Table filtered = table.selectWhere(QueryHelper.column((String)"stop_id").isBetween(524, 624));
        ExamplesTest.out(filtered.first(5));
        CsvWriter.write((Table)filtered, (String)"../data/filtered_bus_stops.csv");
    }

    private static void out(Object o) {
        System.out.println(o);
    }
}

