/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.LongColumnUtils;
import tech.tablesaw.index.LongIndex;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.util.Selection;

public class LongIndexTest {
    private ColumnType[] types = new ColumnType[]{ColumnType.LOCAL_DATE, ColumnType.LONG_INT, ColumnType.CATEGORY};
    private LongIndex index;
    private Table table;

    @Before
    public void setUp() throws Exception {
        this.table = Table.read().csv(CsvReadOptions.builder((String)"../data/BushApproval.csv").columnTypes(this.types));
        this.index = new LongIndex(this.table.longColumn("approval"));
    }

    @Test
    public void testGet() {
        Selection fromCol = this.table.longColumn("approval").select(LongColumnUtils.isEqualTo, 71L);
        Selection fromIdx = this.index.get(71L);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGTE() {
        Selection fromCol = this.table.longColumn("approval").select(LongColumnUtils.isGreaterThanOrEqualTo, 71L);
        Selection fromIdx = this.index.atLeast(71L);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testLTE() {
        Selection fromCol = this.table.longColumn("approval").select(LongColumnUtils.isLessThanOrEqualTo, 71L);
        Selection fromIdx = this.index.atMost(71L);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testLT() {
        Selection fromCol = this.table.longColumn("approval").select(LongColumnUtils.isLessThan, 71L);
        Selection fromIdx = this.index.lessThan(71L);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }

    @Test
    public void testGT() {
        Selection fromCol = this.table.longColumn("approval").select(LongColumnUtils.isGreaterThan, 71L);
        Selection fromIdx = this.index.greaterThan(71L);
        Assert.assertEquals((Object)fromCol, (Object)fromIdx);
    }
}

